/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.bluegreen;

import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.ClientDiscoveryService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientClusterDiscoveryServiceTest {
    private CandidateClusterContext createContext() {
        return new CandidateClusterContext(null, null, null, null, null, null);
    }

    @Test(expected=NoSuchElementException.class)
    public void test_oneIteration() {
        ArrayList<CandidateClusterContext> arrayList = new ArrayList<CandidateClusterContext>();
        int numberOfCandidates = 10;
        for (int i = 0; i < numberOfCandidates; ++i) {
            arrayList.add(this.createContext());
        }
        ClientDiscoveryService discoveryService = new ClientDiscoveryService(1, arrayList);
        int count = 0;
        while (discoveryService.hasNext()) {
            discoveryService.next();
            ++count;
        }
        Assert.assertEquals((long)numberOfCandidates, (long)count);
        discoveryService.next();
    }

    @Test
    public void test_continueFromWhereItleftOff() {
        ArrayList<CandidateClusterContext> arrayList = new ArrayList<CandidateClusterContext>();
        int numberOfCandidates = 10;
        for (int i = 0; i < numberOfCandidates; ++i) {
            arrayList.add(this.createContext());
        }
        ClientDiscoveryService discoveryService = new ClientDiscoveryService(1, arrayList);
        discoveryService.next();
        discoveryService.next();
        discoveryService.resetSearch();
        Assert.assertEquals(arrayList.get(3), (Object)discoveryService.next());
    }

    @Test(expected=NoSuchElementException.class)
    public void test_n_iterations() {
        ArrayList<CandidateClusterContext> arrayList = new ArrayList<CandidateClusterContext>();
        int n = 15;
        for (int i = 0; i < 10; ++i) {
            arrayList.add(this.createContext());
        }
        ClientDiscoveryService discoveryService = new ClientDiscoveryService(n, arrayList);
        int count = 0;
        while (discoveryService.hasNext()) {
            discoveryService.next();
            ++count;
        }
        Assert.assertEquals((long)(10 * n), (long)count);
        discoveryService.next();
    }

    @Test(expected=NoSuchElementException.class)
    public void test_behaviourWhenBlueGreenIsOff() {
        ArrayList<CandidateClusterContext> arrayList = new ArrayList<CandidateClusterContext>();
        CandidateClusterContext candidateClusterContext = this.createContext();
        arrayList.add(candidateClusterContext);
        ClientDiscoveryService discoveryService = new ClientDiscoveryService(1, arrayList);
        Assert.assertEquals((Object)candidateClusterContext, (Object)discoveryService.next());
        Assert.assertFalse((boolean)discoveryService.hasNext());
        discoveryService.next();
    }

    @Test
    public void testCurrentAndNextReturnsCorrect() {
        ArrayList<CandidateClusterContext> arrayList = new ArrayList<CandidateClusterContext>();
        CandidateClusterContext first = this.createContext();
        arrayList.add(first);
        CandidateClusterContext second = this.createContext();
        arrayList.add(second);
        ClientDiscoveryService discoveryService = new ClientDiscoveryService(10, arrayList);
        Assert.assertEquals((Object)first, (Object)discoveryService.current());
        discoveryService.resetSearch();
        TestCase.assertTrue((boolean)discoveryService.hasNext());
        Assert.assertEquals((Object)second, (Object)discoveryService.next());
        Assert.assertEquals((Object)second, (Object)discoveryService.current());
        Assert.assertEquals((Object)first, (Object)discoveryService.next());
        Assert.assertEquals((Object)first, (Object)discoveryService.current());
    }

    @Test
    public void testSingleCandidateBehavior() {
        ArrayList<CandidateClusterContext> arrayList = new ArrayList<CandidateClusterContext>();
        arrayList.add(this.createContext());
        ClientDiscoveryService discoveryService = new ClientDiscoveryService(1, arrayList);
        Assert.assertNotNull((Object)discoveryService.current());
        discoveryService.resetSearch();
        TestCase.assertTrue((boolean)discoveryService.hasNext());
        Assert.assertNotNull((Object)discoveryService.next());
        Assert.assertNotNull((Object)discoveryService.current());
        Assert.assertFalse((boolean)discoveryService.hasNext());
    }
}

