/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.bluegreen;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.ClientSelectors;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientSelectorRaceTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testConcurrency() throws InterruptedException {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        final ClientEngineImpl clientEngineImpl = ClientSelectorRaceTest.getClientEngineImpl((HazelcastInstance)instance);
        LinkedList<Thread> threads = new LinkedList<Thread>();
        int numberOfClients = 100;
        for (int i = 0; i < numberOfClients; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ClientSelectorRaceTest.this.hazelcastFactory.newHazelcastClient();
                }
            });
            thread.start();
            threads.add(thread);
        }
        Thread.sleep(10L);
        clientEngineImpl.applySelector(ClientSelectors.none());
        for (Thread thread : threads) {
            thread.join();
        }
        ClientSelectorRaceTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Collection endpoints = clientEngineImpl.getEndpointManager().getEndpoints();
                Assert.assertEquals((long)0L, (long)endpoints.size());
            }
        });
    }
}

