/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.bluegreen;

import com.hazelcast.client.impl.ClientImpl;
import com.hazelcast.client.impl.ClientSelector;
import com.hazelcast.client.impl.ClientSelectors;
import com.hazelcast.core.Client;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientSelectorsTest
extends HazelcastTestSupport {
    @Test
    public void testAny() {
        String name = ClientSelectorsTest.randomString();
        Set labels = Collections.emptySet();
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress("127.0.0.1"), name, labels);
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.any().select((Client)client));
    }

    private InetSocketAddress createInetSocketAddress(String name) {
        try {
            return new InetSocketAddress(InetAddress.getByName(name), 5000);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testNone() {
        String name = ClientSelectorsTest.randomString();
        Set labels = Collections.emptySet();
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress("127.0.0.1"), name, labels);
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.none().select((Client)client));
    }

    @Test
    public void testLocalhostWithIp() throws UnknownHostException {
        String name = ClientSelectorsTest.randomString();
        Set labels = Collections.emptySet();
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress("localhost"), name, labels);
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"127.0.0.1").select((Client)client));
    }

    @Test
    public void testNameSelector() {
        String name = "client1";
        Set labels = Collections.emptySet();
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress("127.0.0.1"), name, labels);
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.nameSelector((String)"client1").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.nameSelector((String)"clie.*").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.nameSelector((String)".*lie.*").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.nameSelector((String)"c.*t1").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.nameSelector((String)"client2").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.nameSelector((String)"clii.*").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.nameSelector((String)".*lii.*").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.nameSelector((String)"c.*t2").select((Client)client));
    }

    @Test
    public void testNameSelectorsWithNullInput() {
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress("127.0.0.1"), null, null);
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.nameSelector((String)"client").select((Client)client));
    }

    @Test
    public void testLabelSelector() {
        String name = ClientSelectorsTest.randomString();
        HashSet labels = new HashSet();
        Collections.addAll(labels, "admin", "foo", "client1");
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress("127.0.0.1"), name, labels);
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.labelSelector((String)"client1").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.labelSelector((String)"clie.*").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.labelSelector((String)".*lie.*").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.labelSelector((String)"c.*t1").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.labelSelector((String)"client2").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.labelSelector((String)"clii.*").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.labelSelector((String)".*lii.*").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.labelSelector((String)"c.*t2").select((Client)client));
    }

    @Test
    public void testIpSelector_withIpv4() {
        String name = ClientSelectorsTest.randomString();
        Set labels = Collections.emptySet();
        String ip = "213.129.127.80";
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress(ip), name, labels);
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"213.129.127.80").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"213.129.127.*").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"213.129.*.1-100").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"213.129.127.70").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"213.129.126.*").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"213.129.*.1-10").select((Client)client));
    }

    @Test
    public void testIpSelector_withIpv6() {
        String name = ClientSelectorsTest.randomString();
        Set labels = Collections.emptySet();
        String ip = "fe80:0:0:0:45c5:47ee:fe15:493a";
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress(ip), name, labels);
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"fe80:0:0:0:45c5:47ee:fe15:493a").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"fe80:0:0:0:45c5:47ee:fe15:*").select((Client)client));
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"fe80:0:0:0:45c5:47ee:fe15:0-5555").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"fe80:0:0:0:45c5:47ee:fe15:493b").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"fe80:0:0:0:45c5:47ee:fe14:*").select((Client)client));
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.ipSelector((String)"fe80::223:6cff:fe93:0-4444").select((Client)client));
    }

    @Test
    public void testInverse() {
        String name = "client1";
        Set labels = Collections.emptySet();
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress("127.0.0.1"), name, labels);
        Assert.assertFalse((String)client.toString(), (boolean)ClientSelectors.inverse((ClientSelector)ClientSelectors.nameSelector((String)"client1")).select((Client)client));
    }

    @Test
    public void testCombinationWithOr() {
        String name = "client1";
        HashSet labels = new HashSet();
        Collections.addAll(labels, "admin", "foo", "client1");
        String ip = "213.129.127.80";
        ClientImpl client = new ClientImpl(null, this.createInetSocketAddress(ip), name, labels);
        TestCase.assertTrue((String)client.toString(), (boolean)ClientSelectors.or((ClientSelector[])new ClientSelector[]{ClientSelectors.ipSelector((String)"213.129.*.1-100"), ClientSelectors.nameSelector((String)"clie.*")}).select((Client)client));
    }
}

