/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.bluegreen;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.impl.clientside.FailoverClientConfigSupport;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class FailoverConfigTest {
    @Test
    public void testAllClientConfigsAreHandledInMultipleClientConfigSupport() {
        Method[] declaredMethods;
        HashSet allClientConfigMethods = new HashSet();
        Collections.addAll(allClientConfigMethods, "setProperty", "getProperty", "getClassLoader", "getProperties", "setProperties", "getLabels", "getGroupConfig", "getSecurityConfig", "isSmartRouting", "setSmartRouting", "getSocketInterceptorConfig", "setSocketInterceptorConfig", "getConnectionAttemptPeriod", "setConnectionAttemptPeriod", "getConnectionAttemptLimit", "setConnectionAttemptLimit", "getConnectionTimeout", "setConnectionTimeout", "addAddress", "setAddresses", "getAddresses", "isRedoOperation", "setRedoOperation", "getSocketOptions", "setSocketOptions", "setConfigPatternMatcher", "getConfigPatternMatcher", "setSecurityConfig", "getNetworkConfig", "setNetworkConfig", "addReliableTopicConfig", "getReliableTopicConfig", "addNearCacheConfig", "addNearCacheConfig", "addListenerConfig", "addProxyFactoryConfig", "getNearCacheConfig", "getNearCacheConfigMap", "setNearCacheConfigMap", "getFlakeIdGeneratorConfigMap", "findFlakeIdGeneratorConfig", "getFlakeIdGeneratorConfig", "addFlakeIdGeneratorConfig", "setFlakeIdGeneratorConfigMap", "setReliableTopicConfigMap", "getReliableTopicConfigMap", "getCredentials", "setCredentials", "setGroupConfig", "getListenerConfigs", "setListenerConfigs", "getLoadBalancer", "setLoadBalancer", "setClassLoader", "getManagedContext", "setManagedContext", "getExecutorPoolSize", "setExecutorPoolSize", "getProxyFactoryConfigs", "setProxyFactoryConfigs", "getSerializationConfig", "setSerializationConfig", "getNativeMemoryConfig", "setNativeMemoryConfig", "getLicenseKey", "setLicenseKey", "addQueryCacheConfig", "getQueryCacheConfigs", "setQueryCacheConfigs", "getInstanceName", "setInstanceName", "getConnectionStrategyConfig", "setConnectionStrategyConfig", "getUserCodeDeploymentConfig", "setUserCodeDeploymentConfig", "getOrCreateQueryCacheConfig", "getOrNullQueryCacheConfig", "addLabel", "setLabels", "setUserContext", "getUserContext", "equals", "hashCode");
        for (Method method : declaredMethods = ClientConfig.class.getDeclaredMethods()) {
            if (method.getName().startsWith("$") || allClientConfigMethods.contains(method.getName())) continue;
            throw new IllegalStateException("There is a new method on client config. " + method + "Handle it on FailoverClientConfigSupport first, and add it to  allClientConfigMethods set above.");
        }
    }

    @Test
    public void testAllClientNetworkConfigsAreHandledInMultipleClientConfigSupport() {
        Method[] declaredMethods;
        HashSet allClientNetworkConfigMethods = new HashSet();
        Collections.addAll(allClientNetworkConfigMethods, "isSmartRouting", "setSmartRouting", "getSocketInterceptorConfig", "setSocketInterceptorConfig", "getConnectionAttemptPeriod", "setConnectionAttemptPeriod", "getConnectionAttemptLimit", "setConnectionAttemptLimit", "getConnectionTimeout", "setConnectionTimeout", "addAddress", "setAddresses", "getAddresses", "isRedoOperation", "setRedoOperation", "getSocketOptions", "setSocketOptions", "getDiscoveryConfig", "setDiscoveryConfig", "getSSLConfig", "setSSLConfig", "setAwsConfig", "getAwsConfig", "setGcpConfig", "getGcpConfig", "setAzureConfig", "getAzureConfig", "setKubernetesConfig", "getKubernetesConfig", "setEurekaConfig", "getEurekaConfig", "getCloudConfig", "setCloudConfig", "getOutboundPortDefinitions", "getOutboundPorts", "setOutboundPortDefinitions", "setOutboundPorts", "addOutboundPort", "addOutboundPortDefinition", "getClientIcmpPingConfig", "setClientIcmpPingConfig", "equals", "hashCode");
        for (Method method : declaredMethods = ClientNetworkConfig.class.getDeclaredMethods()) {
            if (method.getName().startsWith("$") || allClientNetworkConfigMethods.contains(method.getName())) continue;
            throw new IllegalStateException("There is a new method on client network config. " + method + "Handle it on FailoverClientConfigSupport first, and add it to allClientNetworkConfigMethods set above.");
        }
    }

    @Test
    public void testClientConfigWithSameGroupName() {
        ClientFailoverConfig clientFailoverConfig = new ClientFailoverConfig();
        clientFailoverConfig.addClientConfig(new ClientConfig());
        clientFailoverConfig.addClientConfig(new ClientConfig());
        FailoverClientConfigSupport.resolveClientFailoverConfig((ClientFailoverConfig)clientFailoverConfig);
    }

    @Test
    public void testClientConfigWithDifferentGroupName() {
        ClientFailoverConfig clientFailoverConfig = new ClientFailoverConfig();
        clientFailoverConfig.addClientConfig(new ClientConfig());
        ClientConfig alternativeConfig = new ClientConfig();
        alternativeConfig.getGroupConfig().setName("alternative");
        clientFailoverConfig.addClientConfig(alternativeConfig);
        FailoverClientConfigSupport.resolveClientFailoverConfig((ClientFailoverConfig)clientFailoverConfig);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testClientConfigWith_withAnInvalidChange() {
        ClientFailoverConfig clientFailoverConfig = new ClientFailoverConfig();
        clientFailoverConfig.addClientConfig(new ClientConfig());
        ClientConfig alternativeConfig = new ClientConfig();
        alternativeConfig.getGroupConfig().setName("alternative");
        alternativeConfig.setProperty("newProperty", "newValue");
        clientFailoverConfig.addClientConfig(alternativeConfig);
        FailoverClientConfigSupport.resolveClientFailoverConfig((ClientFailoverConfig)clientFailoverConfig);
    }

    @Test
    public void testClientConfigWith_withAValidChange() {
        ClientFailoverConfig clientFailoverConfig = new ClientFailoverConfig();
        clientFailoverConfig.addClientConfig(new ClientConfig());
        ClientConfig alternativeConfig = new ClientConfig();
        alternativeConfig.getGroupConfig().setName("alternative");
        CredentialsFactoryConfig credentialsFactoryConfig = new CredentialsFactoryConfig();
        credentialsFactoryConfig.setClassName("CustomCredentials");
        alternativeConfig.getSecurityConfig().setCredentialsFactoryConfig(credentialsFactoryConfig);
        clientFailoverConfig.addClientConfig(alternativeConfig);
        FailoverClientConfigSupport.resolveClientFailoverConfig((ClientFailoverConfig)clientFailoverConfig);
    }

    @Test(expected=HazelcastException.class)
    public void test_throwsException_whenFailoverConfigIsIntended_butPassedNull() {
        ClientFailoverConfig clientFailoverConfig = FailoverClientConfigSupport.resolveClientFailoverConfig(null);
        Assert.assertEquals((long)1L, (long)clientFailoverConfig.getClientConfigs().size());
        Assert.assertEquals((Object)"dev", (Object)((ClientConfig)clientFailoverConfig.getClientConfigs().get(0)).getGroupConfig().getName());
    }

    @Test(expected=InvalidConfigurationException.class)
    public void test_throwsException_whenFailoverConfigIsEmpty() {
        FailoverClientConfigSupport.resolveClientFailoverConfig((ClientFailoverConfig)new ClientFailoverConfig());
    }
}

