/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.cache.impl.event.CachePartitionLostEvent;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.partition.IPartitionLostEvent;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCachePartitionLostListenerTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void test_cachePartitionLostListener_registered() {
        String cacheName = ClientCachePartitionLostListenerTest.randomName();
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastClientCachingProvider cachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = cachingProvider.getCacheManager();
        CacheConfig cacheConfig = new CacheConfig();
        Cache cache = cacheManager.createCache(cacheName, (Configuration)cacheConfig);
        ICache iCache = (ICache)cache.unwrap(ICache.class);
        iCache.addPartitionLostListener(new CachePartitionLostListener(){

            public void partitionLost(CachePartitionLostEvent event) {
            }
        });
        this.assertRegistrationsSizeEventually(instance, cacheName, 1);
    }

    @Test
    public void test_cachePartitionLostListener_invoked() {
        String cacheName = ClientCachePartitionLostListenerTest.randomName();
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastServerCachingProvider cachingProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)instance);
        CacheManager cacheManager = cachingProvider.getCacheManager();
        CacheConfig config = new CacheConfig();
        config.setBackupCount(0);
        cacheManager.createCache(cacheName, (Configuration)config);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager clientCacheManager = clientCachingProvider.getCacheManager();
        Cache cache = clientCacheManager.getCache(cacheName);
        ICache iCache = (ICache)cache.unwrap(ICache.class);
        EventCollectingCachePartitionLostListener listener = new EventCollectingCachePartitionLostListener();
        iCache.addPartitionLostListener((CachePartitionLostListener)listener);
        CacheService cacheService = (CacheService)ClientCachePartitionLostListenerTest.getNode((HazelcastInstance)instance).getNodeEngine().getService("hz:impl:cacheService");
        int partitionId = 5;
        cacheService.onPartitionLost(new IPartitionLostEvent(5, 0, null));
        this.assertCachePartitionLostEventEventually(listener, 5);
    }

    @Test
    public void test_cachePartitionLostListener_invoked_fromOtherNode() {
        String cacheName = ClientCachePartitionLostListenerTest.randomName();
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastServerCachingProvider cachingProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)instance1);
        CacheManager cacheManager = cachingProvider.getCacheManager();
        CacheConfig config = new CacheConfig();
        config.setBackupCount(0);
        cacheManager.createCache(cacheName, (Configuration)config);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager clientCacheManager = clientCachingProvider.getCacheManager();
        Cache cache = clientCacheManager.getCache(cacheName);
        ICache iCache = (ICache)cache.unwrap(ICache.class);
        EventCollectingCachePartitionLostListener listener = new EventCollectingCachePartitionLostListener();
        iCache.addPartitionLostListener((CachePartitionLostListener)listener);
        this.assertRegistrationsSizeEventually(instance1, cacheName, 1);
        this.assertRegistrationsSizeEventually(instance2, cacheName, 1);
        CacheService cacheService1 = (CacheService)ClientCachePartitionLostListenerTest.getNode((HazelcastInstance)instance1).getNodeEngine().getService("hz:impl:cacheService");
        CacheService cacheService2 = (CacheService)ClientCachePartitionLostListenerTest.getNode((HazelcastInstance)instance2).getNodeEngine().getService("hz:impl:cacheService");
        int partitionId = 5;
        cacheService1.onPartitionLost(new IPartitionLostEvent(5, 0, null));
        cacheService2.onPartitionLost(new IPartitionLostEvent(5, 0, null));
        this.assertCachePartitionLostEventEventually(listener, 5);
    }

    @Test
    public void test_cachePartitionLostListener_removed() {
        String cacheName = ClientCachePartitionLostListenerTest.randomName();
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastServerCachingProvider cachingProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)instance);
        CacheManager cacheManager = cachingProvider.getCacheManager();
        CacheConfig config = new CacheConfig();
        config.setBackupCount(0);
        cacheManager.createCache(cacheName, (Configuration)config);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager clientCacheManager = clientCachingProvider.getCacheManager();
        Cache cache = clientCacheManager.getCache(cacheName);
        ICache iCache = (ICache)cache.unwrap(ICache.class);
        String registrationId = iCache.addPartitionLostListener((CachePartitionLostListener)Mockito.mock(CachePartitionLostListener.class));
        this.assertRegistrationsSizeEventually(instance, cacheName, 1);
        Assert.assertTrue((boolean)iCache.removePartitionLostListener(registrationId));
        this.assertRegistrationsSizeEventually(instance, cacheName, 0);
    }

    private void assertCachePartitionLostEventEventually(final EventCollectingCachePartitionLostListener listener, final int partitionId) {
        ClientCachePartitionLostListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                List<CachePartitionLostEvent> events = listener.getEvents();
                Assert.assertFalse((boolean)events.isEmpty());
                Assert.assertEquals((long)partitionId, (long)events.get(0).getPartitionId());
            }
        });
    }

    private void assertRegistrationsSizeEventually(final HazelcastInstance instance, final String cacheName, final int size) {
        ClientCachePartitionLostListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                InternalEventService eventService = HazelcastTestSupport.getNode((HazelcastInstance)instance).getNodeEngine().getEventService();
                Collection registrations = eventService.getRegistrations("hz:impl:cacheService", cacheName);
                Assert.assertEquals((long)size, (long)registrations.size());
            }
        });
    }

    private static class EventCollectingCachePartitionLostListener
    implements CachePartitionLostListener {
        private final List<CachePartitionLostEvent> events = Collections.synchronizedList(new LinkedList());

        public void partitionLost(CachePartitionLostEvent event) {
            this.events.add(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<CachePartitionLostEvent> getEvents() {
            List<CachePartitionLostEvent> list = this.events;
            synchronized (list) {
                return new ArrayList<CachePartitionLostEvent>(this.events);
            }
        }
    }
}

