/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheProxyTest
extends ClientTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void clusterRestart_proxyRemainsUsableOnClient() {
        HazelcastInstance instance = this.factory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider cachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = cachingProvider.getCacheManager();
        MutableConfiguration config = new MutableConfiguration().setTypes(String.class, String.class);
        Cache cache = cacheManager.createCache("example", (Configuration)config);
        instance.shutdown();
        final CountDownLatch clientConnectedBack = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED.equals((Object)event.getState())) {
                    clientConnectedBack.countDown();
                }
            }
        });
        this.factory.newHazelcastInstance();
        ClientCacheProxyTest.assertOpenEventually((CountDownLatch)clientConnectedBack);
        Assert.assertNull((Object)cache.get((Object)"key"));
    }

    @Test
    public void clientRestart_proxyRemainsUsableOnClient() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        HazelcastClientCachingProvider cachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = cachingProvider.getCacheManager();
        MutableConfiguration config = new MutableConfiguration().setTypes(String.class, String.class);
        String cacheName = "example";
        cacheManager.createCache(cacheName, (Configuration)config);
        client.shutdown();
        client = this.factory.newHazelcastClient();
        cachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        cacheManager = cachingProvider.getCacheManager();
        Cache cache = cacheManager.getCache(cacheName);
        Assert.assertNull((Object)cache.get((Object)"key"));
    }
}

