/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.nio.serialization.Data;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

class ClientCacheInvalidationListener
extends CacheAddNearCacheInvalidationListenerCodec.AbstractEventHandler
implements EventHandler<ClientMessage> {
    private final AtomicLong invalidationCount = new AtomicLong();

    ClientCacheInvalidationListener() {
    }

    public long getInvalidationCount() {
        return this.invalidationCount.get();
    }

    public void resetInvalidationCount() {
        this.invalidationCount.set(0L);
    }

    public void beforeListenerRegister() {
    }

    public void onListenerRegister() {
    }

    static ClientCacheInvalidationListener createInvalidationEventHandler(ICache clientCache) {
        ClientCacheInvalidationListener invalidationListener = new ClientCacheInvalidationListener();
        ((NearCachedClientCacheProxy)clientCache).addNearCacheInvalidationListener((EventHandler)invalidationListener);
        return invalidationListener;
    }

    public void handleCacheInvalidationEventV10(String name, Data key, String sourceUuid) {
        this.invalidationCount.incrementAndGet();
    }

    public void handleCacheInvalidationEventV14(String name, Data key, String sourceUuid, UUID partitionUuid, long sequence) {
        this.invalidationCount.incrementAndGet();
    }

    public void handleCacheBatchInvalidationEventV10(String name, Collection<Data> keys, Collection<String> sourceUuids) {
        this.invalidationCount.addAndGet(keys.size());
    }

    public void handleCacheBatchInvalidationEventV14(String name, Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
        this.invalidationCount.addAndGet(keys.size());
    }
}

