/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilderTest;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheNearCacheConfigTest {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @Before
    public void setUp() throws Exception {
        this.factory.newHazelcastInstance();
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void native_backed_nearCache_throws_illegalArgumentException_whenNoNativeConfigAvailable() throws Exception {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\"><near-cache name=\"test\"><in-memory-format>NATIVE</in-memory-format></near-cache></hazelcast-client>";
        ClientConfig clientConfig = XmlClientConfigBuilderTest.buildConfig(xml);
        HazelcastClientProxy client = (HazelcastClientProxy)this.factory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = clientCachingProvider.getCacheManager();
        cacheManager.createCache("test", (Configuration)this.newCacheConfig());
    }

    private CacheConfig newCacheConfig() {
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return cacheConfig;
    }
}

