/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.SlowTest;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={SlowTest.class, ParallelTest.class})
public class ClientCacheNearCacheStaleReadTest
extends HazelcastTestSupport {
    private static final int NUM_GETTERS = 7;
    private static final int MAX_RUNTIME = 30;
    private static final String KEY = "key123";
    private static final ILogger LOGGER = Logger.getLogger(ClientCacheNearCacheStaleReadTest.class);
    private AtomicInteger valuePut = new AtomicInteger(0);
    private AtomicBoolean stop = new AtomicBoolean(false);
    private AtomicInteger assertionViolationCount = new AtomicInteger(0);
    private AtomicBoolean failed = new AtomicBoolean(false);
    private HazelcastInstance member;
    private HazelcastInstance client;
    private Cache<String, String> cache;

    @Before
    public void setUp() {
        String cacheName = ClientCacheNearCacheStaleReadTest.randomMapName();
        TestHazelcastFactory factory = new TestHazelcastFactory();
        Config config = this.getConfig().setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), "2");
        ClientConfig clientConfig = this.getClientConfig(cacheName).setProperty(RepairingTask.MAX_TOLERATED_MISS_COUNT.getName(), "0");
        this.member = factory.newHazelcastInstance(config);
        this.client = factory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)this.client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        CacheConfig<String, String> cacheConfig = this.createCacheConfig(cacheName);
        this.cache = cacheManager.createCache(cacheName, cacheConfig);
    }

    @After
    public void tearDown() {
        this.client.shutdown();
        this.member.shutdown();
    }

    @Test
    public void testNoLostInvalidationsEventually() {
        this.testNoLostInvalidationsStrict(false);
    }

    @Test
    public void testNoLostInvalidationsStrict() {
        this.testNoLostInvalidationsStrict(true);
    }

    private void testNoLostInvalidationsStrict(boolean strict) {
        this.runTestInternal();
        if (!strict) {
            ClientCacheNearCacheStaleReadTest.sleepSeconds((int)2);
        }
        int valuePutLast = this.valuePut.get();
        String valueMapStr = (String)this.cache.get((Object)KEY);
        int valueMap = Integer.parseInt(valueMapStr);
        String msg = null;
        if (valueMap < valuePutLast) {
            msg = "Near Cache did *not* become consistent. (valueMap = " + valueMap + ", valuePut = " + valuePutLast + ").";
            this.flushClientNearCache(this.cache);
            String valueMap2Str = (String)this.cache.get((Object)KEY);
            int valueMap2 = Integer.parseInt(valueMap2Str);
            msg = valueMap2 < valuePutLast ? msg + " Unexpected inconsistency! (valueMap2 = " + valueMap2 + ", valuePut = " + valuePutLast + ")." : msg + " Flushing the Near Cache cleared the inconsistency. (valueMap2 = " + valueMap2 + ", valuePut = " + valuePutLast + ").";
        }
        this.client.getLifecycleService().terminate();
        if (msg != null) {
            LOGGER.warning(msg);
            Assert.fail(msg);
        }
        if (strict && this.assertionViolationCount.get() > 0) {
            msg = "Assertion violated " + this.assertionViolationCount.get() + " times.";
            LOGGER.warning(msg);
            Assert.fail((String)msg);
        }
    }

    protected CacheConfig<String, String> createCacheConfig(String cacheName) {
        return new CacheConfig().setName(cacheName).setInMemoryFormat(InMemoryFormat.BINARY);
    }

    protected Config getConfig() {
        return NearCacheTestUtils.getBaseConfig();
    }

    protected ClientConfig getClientConfig(String cacheName) {
        NearCacheConfig nearCacheConfig = this.getNearCacheConfig(cacheName);
        return new ClientConfig().addNearCacheConfig(nearCacheConfig);
    }

    protected NearCacheConfig getNearCacheConfig(String cacheName) {
        return new NearCacheConfig(cacheName).setInMemoryFormat(InMemoryFormat.BINARY).setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.INVALIDATE);
    }

    private void flushClientNearCache(Cache cache) {
        ((NearCachedClientCacheProxy)cache).getNearCache().clear();
    }

    private void runTestInternal() {
        Thread threadPut = new Thread((Runnable)new PutRunnable(), "put0");
        threadPut.start();
        ClientCacheNearCacheStaleReadTest.sleepMillis((int)300);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 7; ++i) {
            Thread thread = new Thread((Runnable)new GetRunnable(), "get" + i);
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        int i = 0;
        while (!this.stop.get() && i++ < 30) {
            ClientCacheNearCacheStaleReadTest.sleepMillis((int)1000);
        }
        if (!this.stop.get()) {
            LOGGER.info("Problem did not occur within 30s.");
        }
        this.stop.set(true);
        ClientCacheNearCacheStaleReadTest.assertJoinable((Thread[])new Thread[]{threadPut});
        for (Thread thread : threads) {
            ClientCacheNearCacheStaleReadTest.assertJoinable((Thread[])new Thread[]{thread});
        }
    }

    private class GetRunnable
    implements Runnable {
        private GetRunnable() {
        }

        @Override
        public void run() {
            LOGGER.info(Thread.currentThread().getName() + " started.");
            int n = 0;
            while (!ClientCacheNearCacheStaleReadTest.this.stop.get()) {
                ++n;
                String valueMapStr = (String)ClientCacheNearCacheStaleReadTest.this.cache.get((Object)ClientCacheNearCacheStaleReadTest.KEY);
                int i = Integer.parseInt(valueMapStr);
                Assert.assertEquals((Object)("" + i), (Object)valueMapStr);
            }
            LOGGER.info(Thread.currentThread().getName() + " performed " + n + " operations.");
        }
    }

    private class PutRunnable
    implements Runnable {
        private PutRunnable() {
        }

        @Override
        public void run() {
            LOGGER.info(Thread.currentThread().getName() + " started.");
            int i = 0;
            while (!ClientCacheNearCacheStaleReadTest.this.stop.get()) {
                int valueMap;
                ClientCacheNearCacheStaleReadTest.this.cache.put((Object)ClientCacheNearCacheStaleReadTest.KEY, (Object)String.valueOf(++i));
                ClientCacheNearCacheStaleReadTest.this.valuePut.set(i);
                String valueMapStr = (String)ClientCacheNearCacheStaleReadTest.this.cache.get((Object)ClientCacheNearCacheStaleReadTest.KEY);
                if (valueMapStr == null || (valueMap = Integer.parseInt(valueMapStr)) == i) continue;
                ClientCacheNearCacheStaleReadTest.this.assertionViolationCount.incrementAndGet();
                LOGGER.warning("Assertion violated! (valueMap = " + valueMap + ", i = " + i + ")");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.warning("Interrupted: " + e.getMessage());
                }
                if ((valueMap = Integer.parseInt(valueMapStr = (String)ClientCacheNearCacheStaleReadTest.this.cache.get((Object)ClientCacheNearCacheStaleReadTest.KEY))) == i) continue;
                LOGGER.warning("Near Cache invalidation lost! (valueMap = " + valueMap + ", i = " + i + ")");
                ClientCacheNearCacheStaleReadTest.this.failed.set(true);
                ClientCacheNearCacheStaleReadTest.this.stop.set(true);
            }
            LOGGER.info(Thread.currentThread().getName() + " performed " + i + " operations.");
        }
    }
}

