/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.nearcache.ClientNearCacheTestSupport;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import com.hazelcast.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class ClientCacheInvalidationMetadataDistortionTest
extends ClientNearCacheTestSupport {
    private static final int CACHE_SIZE = 100000;
    private final AtomicBoolean stopTest = new AtomicBoolean();

    @Test
    public void ensure_nearCachedClient_and_member_data_sync_eventually() {
        Config config = this.createConfig();
        final HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)this.serverInstance);
        CacheManager serverCacheManager = provider.getCacheManager();
        final Cache memberCache = serverCacheManager.createCache("ClientCache", this.createCacheConfig(InMemoryFormat.BINARY));
        for (int i = 0; i < 100000; ++i) {
            memberCache.put((Object)i, (Object)i);
        }
        ClientConfig clientConfig = this.createClientConfig();
        clientConfig.addNearCacheConfig(this.createNearCacheConfig(InMemoryFormat.BINARY));
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        final Cache clientCache = clientCachingProvider.getCacheManager().createCache("ClientCache", this.createCacheConfig(InMemoryFormat.BINARY));
        Thread populateNearCache = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ClientCacheInvalidationMetadataDistortionTest.this.stopTest.get()) {
                    for (int i = 0; i < 100000; ++i) {
                        clientCache.get((Object)i);
                    }
                }
            }
        });
        Thread distortSequence = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ClientCacheInvalidationMetadataDistortionTest.this.stopTest.get()) {
                    ClientCacheInvalidationMetadataDistortionTest.this.distortRandomPartitionSequence("ClientCache", member);
                    HazelcastTestSupport.sleepSeconds((int)1);
                }
            }
        });
        Thread distortUuid = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ClientCacheInvalidationMetadataDistortionTest.this.stopTest.get()) {
                    ClientCacheInvalidationMetadataDistortionTest.this.distortRandomPartitionUuid(member);
                    HazelcastTestSupport.sleepSeconds((int)5);
                }
            }
        });
        Thread put = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ClientCacheInvalidationMetadataDistortionTest.this.stopTest.get()) {
                    int key = RandomPicker.getInt((int)100000);
                    int value = RandomPicker.getInt((int)Integer.MAX_VALUE);
                    memberCache.put((Object)key, (Object)value);
                    HazelcastTestSupport.sleepAtLeastMillis((long)100L);
                }
            }
        });
        put.start();
        populateNearCache.start();
        distortSequence.start();
        distortUuid.start();
        ClientCacheInvalidationMetadataDistortionTest.sleepSeconds((int)60);
        this.stopTest.set(true);
        ClientCacheInvalidationMetadataDistortionTest.assertJoinable((Thread[])new Thread[]{distortUuid, distortSequence, populateNearCache, put});
        ClientCacheInvalidationMetadataDistortionTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                for (int i = 0; i < 100000; ++i) {
                    Integer valueSeenFromMember = (Integer)memberCache.get((Object)i);
                    Integer valueSeenFromClient = (Integer)clientCache.get((Object)i);
                    Assert.assertEquals((Object)valueSeenFromMember, (Object)valueSeenFromClient);
                }
            }
        });
    }

    @Override
    protected Config createConfig() {
        return super.createConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "271").setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true").setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), "10");
    }

    @Override
    protected ClientConfig createClientConfig() {
        return new ClientConfig().setProperty(RepairingTask.MAX_TOLERATED_MISS_COUNT.getName(), "0");
    }

    protected CacheConfig<Integer, Integer> createCacheConfig(InMemoryFormat inMemoryFormat) {
        EvictionConfig evictionConfig = new EvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        CacheConfig cacheConfig = super.createCacheConfig(inMemoryFormat);
        cacheConfig.setEvictionConfig(evictionConfig);
        return cacheConfig;
    }

    @Override
    protected NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat) {
        EvictionConfig evictionConfig = new EvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return super.createNearCacheConfig(inMemoryFormat).setInvalidateOnChange(true).setEvictionConfig(evictionConfig);
    }

    private void distortRandomPartitionSequence(String mapName, HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = ClientCacheInvalidationMetadataDistortionTest.getNodeEngineImpl((HazelcastInstance)member);
        CacheService service = (CacheService)nodeEngineImpl.getService("hz:impl:cacheService");
        CacheEventHandler cacheEventHandler = service.getCacheEventHandler();
        MetaDataGenerator metaDataGenerator = cacheEventHandler.getMetaDataGenerator();
        InternalPartitionService partitionService = nodeEngineImpl.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        int randomPartition = RandomPicker.getInt((int)partitionCount);
        int randomSequence = RandomPicker.getInt((int)Integer.MAX_VALUE);
        metaDataGenerator.setCurrentSequence(mapName, randomPartition, (long)randomSequence);
    }

    private void distortRandomPartitionUuid(HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = ClientCacheInvalidationMetadataDistortionTest.getNodeEngineImpl((HazelcastInstance)member);
        int partitionCount = nodeEngineImpl.getPartitionService().getPartitionCount();
        CacheService service = (CacheService)nodeEngineImpl.getService("hz:impl:cacheService");
        CacheEventHandler cacheEventHandler = service.getCacheEventHandler();
        MetaDataGenerator metaDataGenerator = cacheEventHandler.getMetaDataGenerator();
        UUID uuid = UuidUtil.newUnsecureUUID();
        int randomPartition = RandomPicker.getInt((int)partitionCount);
        metaDataGenerator.setUuid(randomPartition, uuid);
    }
}

