/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.CacheManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheMetaDataGeneratorTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME = "CacheMetaDataGeneratorTest";
    private static final String PREFIXED_CACHE_NAME = "/hz/CacheMetaDataGeneratorTest";
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private ClientConfig clientConfig;
    private CacheConfig<Integer, Integer> cacheConfig;
    private ICache<Integer, Integer> serverCache;
    private HazelcastInstance server;

    @Before
    public void setUp() {
        NearCacheConfig nearCacheConfig = this.getNearCacheConfig();
        this.clientConfig = this.getClientConfig().addNearCacheConfig(nearCacheConfig);
        this.cacheConfig = this.getCacheConfig(CACHE_NAME);
        Config config = this.getConfig();
        this.server = this.factory.newHazelcastInstance(config);
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)this.server);
        CacheManager serverCacheManager = provider.getCacheManager();
        this.serverCache = (ICache)serverCacheManager.createCache(CACHE_NAME, this.cacheConfig);
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void destroying_cache_removes_related_metadata_when_near_cache_exists() {
        ICache<Integer, Integer> clientCache = this.createCacheFromNewClient();
        this.serverCache.put((Object)1, (Object)1);
        Assert.assertNotNull(ClientCacheMetaDataGeneratorTest.getMetaDataGenerator(this.server).getSequenceGenerators().get(PREFIXED_CACHE_NAME));
        clientCache.destroy();
        Assert.assertNull(ClientCacheMetaDataGeneratorTest.getMetaDataGenerator(this.server).getSequenceGenerators().get(PREFIXED_CACHE_NAME));
    }

    @Test
    public void destroying_cache_removes_related_metadata_when_near_cache_not_exists() {
        this.serverCache.put((Object)1, (Object)1);
        Assert.assertNull(ClientCacheMetaDataGeneratorTest.getMetaDataGenerator(this.server).getSequenceGenerators().get(PREFIXED_CACHE_NAME));
        this.serverCache.destroy();
        Assert.assertNull(ClientCacheMetaDataGeneratorTest.getMetaDataGenerator(this.server).getSequenceGenerators().get(PREFIXED_CACHE_NAME));
    }

    protected Config getConfig() {
        return NearCacheTestUtils.getBaseConfig();
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    protected CacheConfig<Integer, Integer> getCacheConfig(String cacheName) {
        EvictionConfig evictionConfig = new EvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return new CacheConfig().setName(cacheName).setEvictionConfig(evictionConfig);
    }

    protected NearCacheConfig getNearCacheConfig() {
        return new NearCacheConfig(CACHE_NAME).setInvalidateOnChange(true);
    }

    private ICache<Integer, Integer> createCacheFromNewClient() {
        HazelcastClientProxy client = (HazelcastClientProxy)this.factory.newHazelcastClient(this.clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = clientCachingProvider.getCacheManager();
        ICache cache = (ICache)cacheManager.createCache(CACHE_NAME, this.cacheConfig);
        ClientCacheMetaDataGeneratorTest.assertInstanceOf(NearCachedClientCacheProxy.class, (Object)cache);
        return cache;
    }

    private static MetaDataGenerator getMetaDataGenerator(HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = ClientCacheMetaDataGeneratorTest.getNodeEngineImpl((HazelcastInstance)member);
        CacheService service = (CacheService)nodeEngineImpl.getService("hz:impl:cacheService");
        CacheEventHandler cacheEventHandler = service.getCacheEventHandler();
        return cacheEventHandler.getMetaDataGenerator();
    }
}

