/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.map.impl.nearcache.invalidation.MemberMapReconciliationTest;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheReconciliationTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME = "ClientCacheReconciliationTest";
    private static final int RECONCILIATION_INTERVAL_SECS = 3;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private CacheConfig<Integer, Integer> cacheConfig;
    private ClientConfig clientConfig;
    private Cache<Integer, Integer> serverCache;
    private Cache<Integer, Integer> clientCache;

    @Before
    public void setUp() {
        EvictionConfig evictionConfig = new EvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        this.cacheConfig = new CacheConfig().setEvictionConfig(evictionConfig);
        NearCacheConfig nearCacheConfig = new NearCacheConfig(CACHE_NAME).setInvalidateOnChange(true);
        this.clientConfig = new ClientConfig().setProperty(RepairingTask.MAX_TOLERATED_MISS_COUNT.getName(), "0").setProperty(RepairingTask.RECONCILIATION_INTERVAL_SECONDS.getName(), String.valueOf(3)).setProperty(RepairingTask.MIN_RECONCILIATION_INTERVAL_SECONDS.getName(), String.valueOf(3)).addNearCacheConfig(nearCacheConfig);
        Config config = NearCacheTestUtils.getBaseConfig().setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE)).setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)server);
        CacheManager serverCacheManager = provider.getCacheManager();
        this.serverCache = serverCacheManager.createCache(CACHE_NAME, this.cacheConfig);
        this.clientCache = this.createCacheFromNewClient();
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void test_reconciliation_does_not_cause_premature_removal() {
        int i;
        int total = 100;
        for (i = 0; i < total; ++i) {
            this.serverCache.put((Object)i, (Object)i);
        }
        for (i = 0; i < total; ++i) {
            this.clientCache.get((Object)i);
        }
        Cache<Integer, Integer> cacheFromNewClient = this.createCacheFromNewClient();
        for (int i2 = 0; i2 < total; ++i2) {
            cacheFromNewClient.get((Object)i2);
        }
        NearCacheStats nearCacheStats = ((ICache)cacheFromNewClient).getLocalCacheStatistics().getNearCacheStatistics();
        MemberMapReconciliationTest.assertStats((NearCacheStats)nearCacheStats, (int)total, (int)0, (int)total);
        ClientCacheReconciliationTest.sleepSeconds((int)6);
        for (int i3 = 0; i3 < total; ++i3) {
            cacheFromNewClient.get((Object)i3);
        }
        MemberMapReconciliationTest.assertStats((NearCacheStats)nearCacheStats, (int)total, (int)total, (int)total);
    }

    private Cache<Integer, Integer> createCacheFromNewClient() {
        HazelcastClientProxy client = (HazelcastClientProxy)this.factory.newHazelcastClient(this.clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = clientCachingProvider.getCacheManager();
        Cache cache = cacheManager.createCache(CACHE_NAME, this.cacheConfig);
        ClientCacheReconciliationTest.assertInstanceOf(NearCachedClientCacheProxy.class, (Object)cache);
        return cache;
    }
}

