/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.nearcache;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.DataStructureAdapterMethod;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCacheSerializationCountTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheSerializationCountConfigBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import javax.cache.CacheManager;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheNearCacheSerializationCountTest
extends AbstractNearCacheSerializationCountTest<Data, String> {
    @Parameterized.Parameter
    public DataStructureAdapter.DataStructureMethods method;
    @Parameterized.Parameter(value=1)
    public int[] keySerializationCounts;
    @Parameterized.Parameter(value=2)
    public int[] keyDeserializationCounts;
    @Parameterized.Parameter(value=3)
    public int[] valueSerializationCounts;
    @Parameterized.Parameter(value=4)
    public int[] valueDeserializationCounts;
    @Parameterized.Parameter(value=5)
    public InMemoryFormat cacheInMemoryFormat;
    @Parameterized.Parameter(value=6)
    public InMemoryFormat nearCacheInMemoryFormat;
    @Parameterized.Parameter(value=7)
    public Boolean invalidateOnChange;
    @Parameterized.Parameter(value=8)
    public Boolean serializeKeys;
    @Parameterized.Parameter(value=9)
    public NearCacheConfig.LocalUpdatePolicy localUpdatePolicy;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="method:{0} cacheFormat:{5} nearCacheFormat:{6} invalidateOnChange:{7} serializeKeys:{8} localUpdatePolicy:{9}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, null, null, null, null}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, true, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, true, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, true, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, true, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, false, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, false, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, false, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, false, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, true, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, true, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, true, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, true, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, false, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, false, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, false, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, false, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, null, null, null, null}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, true, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, true, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, true, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, true, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, false, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, false, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, false, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, false, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, true, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, true, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, true, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, true, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, false, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, false, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, false, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, false, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, null, null, null, null}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, true, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, true, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, true, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)2, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, true, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, null, null, null, null}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, false, true, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)2, (int)0, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, false, true, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, false, false, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {DataStructureAdapter.DataStructureMethods.GET_ALL, ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientCacheNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, false, false, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE});
    }

    @Before
    public void setUp() {
        this.testMethod = this.method;
        this.expectedKeySerializationCounts = this.keySerializationCounts;
        this.expectedKeyDeserializationCounts = this.keyDeserializationCounts;
        this.expectedValueSerializationCounts = this.valueSerializationCounts;
        this.expectedValueDeserializationCounts = this.valueDeserializationCounts;
        if (this.nearCacheInMemoryFormat != null) {
            this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)this.nearCacheInMemoryFormat, (boolean)this.serializeKeys).setInvalidateOnChange(this.invalidateOnChange.booleanValue()).setLocalUpdatePolicy(this.localUpdatePolicy);
        }
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected void addConfiguration(NearCacheSerializationCountConfigBuilder configBuilder) {
        configBuilder.append(this.method);
        configBuilder.append((Object)this.cacheInMemoryFormat);
        configBuilder.append((Object)this.nearCacheInMemoryFormat);
        configBuilder.append((Object)this.invalidateOnChange);
        configBuilder.append((Object)this.serializeKeys);
        configBuilder.append((Object)this.localUpdatePolicy);
    }

    protected void assumeThatMethodIsAvailable(DataStructureAdapterMethod method) {
        NearCacheTestUtils.assumeThatMethodIsAvailable(ICacheDataStructureAdapter.class, (DataStructureAdapterMethod)method);
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext() {
        Config config = this.getConfig().setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(Integer.MAX_VALUE)).setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE)).setProperty(GroupProperty.PARTITION_COUNT.getName(), "1").setProperty(GroupProperty.PARTITION_OPERATION_THREAD_COUNT.getName(), "1");
        ClientCacheNearCacheSerializationCountTest.prepareSerializationConfig((SerializationConfig)config.getSerializationConfig());
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastServerCachingProvider memberProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)member);
        HazelcastServerCacheManager memberCacheManager = (HazelcastServerCacheManager)memberProvider.getCacheManager();
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.cacheInMemoryFormat);
        ICache memberCache = memberCacheManager.createCache("defaultNearCache", cacheConfig);
        return this.createNearCacheContextBuilder(cacheConfig).setDataInstance(member).setDataAdapter((DataStructureAdapter)new ICacheDataStructureAdapter(memberCache)).setMemberCacheManager(memberCacheManager).build();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createNearCacheContext() {
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.cacheInMemoryFormat);
        return this.createNearCacheContextBuilder(cacheConfig).build();
    }

    protected Config getConfig() {
        return ClientCacheNearCacheSerializationCountTest.smallInstanceConfig();
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private <K, V> CacheConfig<K, V> createCacheConfig(InMemoryFormat inMemoryFormat) {
        CacheConfig cacheConfig = new CacheConfig().setName("defaultNearCache").setInMemoryFormat(inMemoryFormat).setBackupCount(0).setAsyncBackupCount(0);
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            cacheConfig.getEvictionConfig().setEvictionPolicy(EvictionPolicy.LRU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE).setSize(90);
        }
        return cacheConfig;
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder(CacheConfig<K, V> cacheConfig) {
        ClientConfig clientConfig = this.getClientConfig();
        if (this.nearCacheConfig != null) {
            clientConfig.addNearCacheConfig(this.nearCacheConfig);
        }
        ClientCacheNearCacheSerializationCountTest.prepareSerializationConfig((SerializationConfig)clientConfig.getSerializationConfig());
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        String cacheNameWithPrefix = cacheManager.getCacheNameWithPrefix("defaultNearCache");
        ICache clientCache = cacheManager.createCache("defaultNearCache", cacheConfig);
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache(cacheNameWithPrefix);
        return new NearCacheTestContextBuilder(this.nearCacheConfig, (SerializationService)client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new ICacheDataStructureAdapter(clientCache)).setNearCache(nearCache).setNearCacheManager(nearCacheManager).setCacheManager((CacheManager)cacheManager);
    }
}

