/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.XMLConfigBuilderTest;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.topic.TopicOverloadPolicy;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractClientConfigBuilderTest
extends HazelcastTestSupport {
    protected ClientConfig fullClientConfig;
    protected ClientConfig defaultClientConfig;

    @Test
    public void testNetworkConfig() {
        ClientNetworkConfig networkConfig = this.fullClientConfig.getNetworkConfig();
        Assert.assertEquals((long)2L, (long)networkConfig.getConnectionAttemptLimit());
        Assert.assertEquals((long)2L, (long)networkConfig.getAddresses().size());
        AbstractClientConfigBuilderTest.assertContains((Collection)networkConfig.getAddresses(), (Object)"127.0.0.1");
        AbstractClientConfigBuilderTest.assertContains((Collection)networkConfig.getAddresses(), (Object)"127.0.0.2");
        Collection allowedPorts = networkConfig.getOutboundPortDefinitions();
        Assert.assertEquals((long)2L, (long)allowedPorts.size());
        Assert.assertTrue((boolean)allowedPorts.contains("34600"));
        Assert.assertTrue((boolean)allowedPorts.contains("34700-34710"));
        Assert.assertTrue((boolean)networkConfig.isSmartRouting());
        Assert.assertTrue((boolean)networkConfig.isRedoOperation());
        SocketInterceptorConfig socketInterceptorConfig = networkConfig.getSocketInterceptorConfig();
        Assert.assertTrue((boolean)socketInterceptorConfig.isEnabled());
        Assert.assertEquals((Object)"com.hazelcast.examples.MySocketInterceptor", (Object)socketInterceptorConfig.getClassName());
        Assert.assertEquals((Object)"bar", (Object)socketInterceptorConfig.getProperty("foo"));
        ClientAwsConfig awsConfig = networkConfig.getAwsConfig();
        Assert.assertTrue((boolean)awsConfig.isEnabled());
        Assert.assertEquals((Object)"TEST_ACCESS_KEY", (Object)awsConfig.getProperty("access-key"));
        Assert.assertEquals((Object)"TEST_SECRET_KEY", (Object)awsConfig.getProperty("secret-key"));
        Assert.assertEquals((Object)"us-east-1", (Object)awsConfig.getProperty("region"));
        Assert.assertEquals((Object)"ec2.amazonaws.com", (Object)awsConfig.getProperty("host-header"));
        Assert.assertEquals((Object)"type", (Object)awsConfig.getProperty("tag-key"));
        Assert.assertEquals((Object)"hz-nodes", (Object)awsConfig.getProperty("tag-value"));
        Assert.assertEquals((Object)"11", (Object)awsConfig.getProperty("connection-timeout-seconds"));
        Assert.assertFalse((boolean)networkConfig.getGcpConfig().isEnabled());
        Assert.assertFalse((boolean)networkConfig.getAzureConfig().isEnabled());
        Assert.assertFalse((boolean)networkConfig.getKubernetesConfig().isEnabled());
        Assert.assertFalse((boolean)networkConfig.getEurekaConfig().isEnabled());
    }

    @Test
    public void testSerializationConfig() {
        SerializationConfig serializationConfig = this.fullClientConfig.getSerializationConfig();
        Assert.assertEquals((long)3L, (long)serializationConfig.getPortableVersion());
        Map dsClasses = serializationConfig.getDataSerializableFactoryClasses();
        Assert.assertEquals((long)1L, (long)dsClasses.size());
        Assert.assertEquals((Object)"com.hazelcast.examples.DataSerializableFactory", dsClasses.get(1));
        Map pfClasses = serializationConfig.getPortableFactoryClasses();
        Assert.assertEquals((long)1L, (long)pfClasses.size());
        Assert.assertEquals((Object)"com.hazelcast.examples.PortableFactory", pfClasses.get(2));
        Collection serializerConfigs = serializationConfig.getSerializerConfigs();
        Assert.assertEquals((long)1L, (long)serializerConfigs.size());
        SerializerConfig serializerConfig = (SerializerConfig)serializerConfigs.iterator().next();
        Assert.assertEquals((Object)"com.hazelcast.examples.DummyType", (Object)serializerConfig.getTypeClassName());
        Assert.assertEquals((Object)"com.hazelcast.examples.SerializerFactory", (Object)serializerConfig.getClassName());
        GlobalSerializerConfig globalSerializerConfig = serializationConfig.getGlobalSerializerConfig();
        Assert.assertEquals((Object)"com.hazelcast.examples.GlobalSerializerFactory", (Object)globalSerializerConfig.getClassName());
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)serializationConfig.getByteOrder());
        Assert.assertTrue((boolean)serializationConfig.isCheckClassDefErrors());
        Assert.assertFalse((boolean)serializationConfig.isAllowUnsafe());
        Assert.assertFalse((boolean)serializationConfig.isEnableCompression());
        Assert.assertTrue((boolean)serializationConfig.isEnableSharedObject());
        Assert.assertTrue((boolean)serializationConfig.isUseNativeByteOrder());
        JavaSerializationFilterConfig javaSerializationFilterConfig = serializationConfig.getJavaSerializationFilterConfig();
        ClassFilter blacklist = javaSerializationFilterConfig.getBlacklist();
        Assert.assertEquals((long)1L, (long)blacklist.getClasses().size());
        Assert.assertTrue((boolean)blacklist.getClasses().contains("com.acme.app.BeanComparator"));
        ClassFilter whitelist = javaSerializationFilterConfig.getWhitelist();
        Assert.assertEquals((long)2L, (long)whitelist.getClasses().size());
        Assert.assertTrue((boolean)whitelist.getClasses().contains("java.lang.String"));
        Assert.assertTrue((boolean)whitelist.getClasses().contains("example.Foo"));
        Assert.assertEquals((long)2L, (long)whitelist.getPackages().size());
        Assert.assertTrue((boolean)whitelist.getPackages().contains("com.acme.app"));
        Assert.assertTrue((boolean)whitelist.getPackages().contains("com.acme.app.subpkg"));
        Assert.assertEquals((long)3L, (long)whitelist.getPrefixes().size());
        Assert.assertTrue((boolean)whitelist.getPrefixes().contains("java"));
        Assert.assertTrue((boolean)whitelist.getPrefixes().contains("["));
        Assert.assertTrue((boolean)whitelist.getPrefixes().contains("com."));
    }

    @Test
    public void testProxyFactories() {
        List pfc = this.fullClientConfig.getProxyFactoryConfigs();
        Assert.assertEquals((long)3L, (long)pfc.size());
        AbstractClientConfigBuilderTest.assertContains((Collection)pfc, (Object)new ProxyFactoryConfig("com.hazelcast.examples.ProxyXYZ1", "sampleService1"));
        AbstractClientConfigBuilderTest.assertContains((Collection)pfc, (Object)new ProxyFactoryConfig("com.hazelcast.examples.ProxyXYZ2", "sampleService1"));
        AbstractClientConfigBuilderTest.assertContains((Collection)pfc, (Object)new ProxyFactoryConfig("com.hazelcast.examples.ProxyXYZ3", "sampleService3"));
    }

    @Test
    public void testNearCacheConfigs() {
        Assert.assertEquals((long)2L, (long)this.fullClientConfig.getNearCacheConfigMap().size());
        NearCacheConfig nearCacheConfig = this.fullClientConfig.getNearCacheConfig("asd");
        Assert.assertEquals((long)2000L, (long)nearCacheConfig.getMaxSize());
        Assert.assertEquals((long)2000L, (long)nearCacheConfig.getEvictionConfig().getSize());
        Assert.assertEquals((long)90L, (long)nearCacheConfig.getTimeToLiveSeconds());
        Assert.assertEquals((long)100L, (long)nearCacheConfig.getMaxIdleSeconds());
        Assert.assertEquals((Object)"LFU", (Object)nearCacheConfig.getEvictionPolicy());
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)nearCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertTrue((boolean)nearCacheConfig.isInvalidateOnChange());
        Assert.assertTrue((boolean)nearCacheConfig.isSerializeKeys());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)nearCacheConfig.getInMemoryFormat());
        NearCacheConfig evictableNearCacheConfig = this.fullClientConfig.getNearCacheConfig("NearCacheEvictionConfigExample");
        EvictionConfig nearCacheEvictionConfig = evictableNearCacheConfig.getEvictionConfig();
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)nearCacheEvictionConfig.getEvictionPolicy());
        Assert.assertEquals((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT, (Object)nearCacheEvictionConfig.getMaximumSizePolicy());
        Assert.assertEquals((long)10000L, (long)nearCacheEvictionConfig.getSize());
        Assert.assertEquals((Object)"com.hazelcast.examples.MyEvictionComparator", (Object)nearCacheEvictionConfig.getComparatorClassName());
    }

    @Test
    public void testSSLConfigs() {
        SSLConfig sslConfig = this.fullClientConfig.getNetworkConfig().getSSLConfig();
        Assert.assertNotNull((Object)sslConfig);
        Assert.assertFalse((boolean)sslConfig.isEnabled());
        Assert.assertEquals((Object)"com.hazelcast.nio.ssl.BasicSSLContextFactory", (Object)sslConfig.getFactoryClassName());
        Assert.assertEquals((long)7L, (long)sslConfig.getProperties().size());
        Assert.assertEquals((Object)"TLS", (Object)sslConfig.getProperty("protocol"));
        Assert.assertEquals((Object)"/opt/hazelcast-client.truststore", (Object)sslConfig.getProperty("trustStore"));
        Assert.assertEquals((Object)"secret.123456", (Object)sslConfig.getProperty("trustStorePassword"));
        Assert.assertEquals((Object)"JKS", (Object)sslConfig.getProperty("trustStoreType"));
        Assert.assertEquals((Object)"/opt/hazelcast-client.keystore", (Object)sslConfig.getProperty("keyStore"));
        Assert.assertEquals((Object)"keystorePassword123", (Object)sslConfig.getProperty("keyStorePassword"));
        Assert.assertEquals((Object)"JKS", (Object)sslConfig.getProperty("keyStoreType"));
    }

    @Test
    public void testNearCacheConfig_withEvictionConfig_withPreloaderConfig() throws IOException {
        URL schemaResource = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-test.xml");
        ClientConfig clientConfig = new XmlClientConfigBuilder(schemaResource).build();
        Assert.assertEquals((Object)"MyInstanceName", (Object)clientConfig.getInstanceName());
        NearCacheConfig nearCacheConfig = clientConfig.getNearCacheConfig("nearCacheWithEvictionAndPreloader");
        Assert.assertEquals((long)10000L, (long)nearCacheConfig.getTimeToLiveSeconds());
        Assert.assertEquals((long)5000L, (long)nearCacheConfig.getMaxIdleSeconds());
        Assert.assertFalse((boolean)nearCacheConfig.isInvalidateOnChange());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)nearCacheConfig.getInMemoryFormat());
        Assert.assertTrue((boolean)nearCacheConfig.isCacheLocalEntries());
        Assert.assertNotNull((Object)nearCacheConfig.getEvictionConfig());
        Assert.assertEquals((long)100L, (long)nearCacheConfig.getEvictionConfig().getSize());
        Assert.assertEquals((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT, (Object)nearCacheConfig.getEvictionConfig().getMaximumSizePolicy());
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)nearCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertNotNull((Object)nearCacheConfig.getPreloaderConfig());
        Assert.assertTrue((boolean)nearCacheConfig.getPreloaderConfig().isEnabled());
        Assert.assertEquals((Object)"/tmp/myNearCache", (Object)nearCacheConfig.getPreloaderConfig().getDirectory());
        Assert.assertEquals((long)2342L, (long)nearCacheConfig.getPreloaderConfig().getStoreInitialDelaySeconds());
        Assert.assertEquals((long)4223L, (long)nearCacheConfig.getPreloaderConfig().getStoreIntervalSeconds());
    }

    @Test
    public void testQueryCacheFullConfig() throws Exception {
        QueryCacheConfig queryCacheClassPredicateConfig = (QueryCacheConfig)((Map)this.fullClientConfig.getQueryCacheConfigs().get("map-name")).get("query-cache-class-name-predicate");
        QueryCacheConfig queryCacheSqlPredicateConfig = (QueryCacheConfig)((Map)this.fullClientConfig.getQueryCacheConfigs().get("map-name")).get("query-cache-sql-predicate");
        EntryListenerConfig entryListenerConfig = (EntryListenerConfig)queryCacheClassPredicateConfig.getEntryListenerConfigs().get(0);
        Assert.assertEquals((Object)"query-cache-class-name-predicate", (Object)queryCacheClassPredicateConfig.getName());
        Assert.assertTrue((boolean)entryListenerConfig.isIncludeValue());
        Assert.assertFalse((boolean)entryListenerConfig.isLocal());
        Assert.assertEquals((Object)"com.hazelcast.examples.EntryListener", (Object)entryListenerConfig.getClassName());
        Assert.assertTrue((boolean)queryCacheClassPredicateConfig.isIncludeValue());
        Assert.assertEquals((long)1L, (long)queryCacheClassPredicateConfig.getBatchSize());
        Assert.assertEquals((long)16L, (long)queryCacheClassPredicateConfig.getBufferSize());
        Assert.assertEquals((long)0L, (long)queryCacheClassPredicateConfig.getDelaySeconds());
        EvictionConfig evictionConfig = queryCacheClassPredicateConfig.getEvictionConfig();
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)evictionConfig.getEvictionPolicy());
        Assert.assertEquals((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT, (Object)evictionConfig.getMaximumSizePolicy());
        Assert.assertEquals((long)10000L, (long)evictionConfig.getSize());
        Assert.assertEquals((Object)"com.hazelcast.examples.MyEvictionComparator", (Object)evictionConfig.getComparatorClassName());
        Assert.assertEquals((Object)InMemoryFormat.BINARY, (Object)queryCacheClassPredicateConfig.getInMemoryFormat());
        Assert.assertFalse((boolean)queryCacheClassPredicateConfig.isCoalesce());
        Assert.assertTrue((boolean)queryCacheClassPredicateConfig.isPopulate());
        for (MapIndexConfig mapIndexConfig : queryCacheClassPredicateConfig.getIndexConfigs()) {
            Assert.assertEquals((Object)"name", (Object)mapIndexConfig.getAttribute());
            Assert.assertFalse((boolean)mapIndexConfig.isOrdered());
        }
        Assert.assertEquals((Object)"com.hazelcast.examples.ExamplePredicate", (Object)queryCacheClassPredicateConfig.getPredicateConfig().getClassName());
        Assert.assertEquals((Object)"query-cache-sql-predicate", (Object)queryCacheSqlPredicateConfig.getName());
        Assert.assertEquals((Object)"%age=40", (Object)queryCacheSqlPredicateConfig.getPredicateConfig().getSql());
    }

    @Test
    public void testConnectionStrategyConfig() {
        ClientConnectionStrategyConfig connectionStrategyConfig = this.fullClientConfig.getConnectionStrategyConfig();
        Assert.assertTrue((boolean)connectionStrategyConfig.isAsyncStart());
        Assert.assertEquals((Object)ClientConnectionStrategyConfig.ReconnectMode.ASYNC, (Object)connectionStrategyConfig.getReconnectMode());
    }

    @Test
    public void testConnectionStrategyConfig_defaults() {
        ClientConnectionStrategyConfig connectionStrategyConfig = this.defaultClientConfig.getConnectionStrategyConfig();
        Assert.assertFalse((boolean)connectionStrategyConfig.isAsyncStart());
        Assert.assertEquals((Object)ClientConnectionStrategyConfig.ReconnectMode.ON, (Object)connectionStrategyConfig.getReconnectMode());
    }

    @Test
    public void testExponentialConnectionRetryConfig() {
        ClientConnectionStrategyConfig connectionStrategyConfig = this.fullClientConfig.getConnectionStrategyConfig();
        ConnectionRetryConfig exponentialRetryConfig = connectionStrategyConfig.getConnectionRetryConfig();
        Assert.assertTrue((boolean)exponentialRetryConfig.isEnabled());
        Assert.assertTrue((boolean)exponentialRetryConfig.isFailOnMaxBackoff());
        Assert.assertEquals((double)0.5, (double)exponentialRetryConfig.getJitter(), (double)0.0);
        Assert.assertEquals((long)2000L, (long)exponentialRetryConfig.getInitialBackoffMillis());
        Assert.assertEquals((long)60000L, (long)exponentialRetryConfig.getMaxBackoffMillis());
        Assert.assertEquals((double)3.0, (double)exponentialRetryConfig.getMultiplier(), (double)0.0);
    }

    @Test
    public void testExponentialConnectionRetryConfig_defaults() {
        ClientConnectionStrategyConfig connectionStrategyConfig = this.defaultClientConfig.getConnectionStrategyConfig();
        ConnectionRetryConfig exponentialRetryConfig = connectionStrategyConfig.getConnectionRetryConfig();
        Assert.assertFalse((boolean)exponentialRetryConfig.isEnabled());
        Assert.assertFalse((boolean)exponentialRetryConfig.isFailOnMaxBackoff());
        Assert.assertEquals((double)0.2, (double)exponentialRetryConfig.getJitter(), (double)0.0);
        Assert.assertEquals((long)1000L, (long)exponentialRetryConfig.getInitialBackoffMillis());
        Assert.assertEquals((long)30000L, (long)exponentialRetryConfig.getMaxBackoffMillis());
        Assert.assertEquals((double)2.0, (double)exponentialRetryConfig.getMultiplier(), (double)0.0);
    }

    @Test
    public void testLeftovers() {
        Assert.assertEquals((long)40L, (long)this.fullClientConfig.getExecutorPoolSize());
        Assert.assertEquals((Object)"com.hazelcast.client.util.RandomLB", (Object)this.fullClientConfig.getLoadBalancer().getClass().getName());
        List listenerConfigs = this.fullClientConfig.getListenerConfigs();
        Assert.assertEquals((long)3L, (long)listenerConfigs.size());
        AbstractClientConfigBuilderTest.assertContains((Collection)listenerConfigs, (Object)new ListenerConfig("com.hazelcast.examples.MembershipListener"));
        AbstractClientConfigBuilderTest.assertContains((Collection)listenerConfigs, (Object)new ListenerConfig("com.hazelcast.examples.InstanceListener"));
        AbstractClientConfigBuilderTest.assertContains((Collection)listenerConfigs, (Object)new ListenerConfig("com.hazelcast.examples.MigrationListener"));
    }

    @Test
    public void testClientIcmpPingConfig() {
        ClientIcmpPingConfig icmpPingConfig = this.fullClientConfig.getNetworkConfig().getClientIcmpPingConfig();
        Assert.assertEquals((Object)false, (Object)icmpPingConfig.isEnabled());
        Assert.assertEquals((long)2000L, (long)icmpPingConfig.getTimeoutMilliseconds());
        Assert.assertEquals((long)3000L, (long)icmpPingConfig.getIntervalMilliseconds());
        Assert.assertEquals((long)100L, (long)icmpPingConfig.getTtl());
        Assert.assertEquals((long)5L, (long)icmpPingConfig.getMaxAttempts());
        Assert.assertEquals((Object)false, (Object)icmpPingConfig.isEchoFailFastOnStartup());
    }

    @Test
    public void testClientIcmpPingConfig_defaults() {
        ClientIcmpPingConfig icmpPingConfig = this.defaultClientConfig.getNetworkConfig().getClientIcmpPingConfig();
        Assert.assertEquals((Object)false, (Object)icmpPingConfig.isEnabled());
        Assert.assertEquals((long)1000L, (long)icmpPingConfig.getTimeoutMilliseconds());
        Assert.assertEquals((long)1000L, (long)icmpPingConfig.getIntervalMilliseconds());
        Assert.assertEquals((long)255L, (long)icmpPingConfig.getTtl());
        Assert.assertEquals((long)2L, (long)icmpPingConfig.getMaxAttempts());
        Assert.assertEquals((Object)true, (Object)icmpPingConfig.isEchoFailFastOnStartup());
    }

    @Test
    public void testReliableTopic() {
        ClientReliableTopicConfig reliableTopicConfig = this.fullClientConfig.getReliableTopicConfig("rel-topic");
        Assert.assertEquals((long)100L, (long)reliableTopicConfig.getReadBatchSize());
        Assert.assertEquals((Object)TopicOverloadPolicy.DISCARD_NEWEST, (Object)reliableTopicConfig.getTopicOverloadPolicy());
    }

    @Test
    public void testCloudConfig() {
        ClientCloudConfig cloudConfig = this.fullClientConfig.getNetworkConfig().getCloudConfig();
        Assert.assertEquals((Object)false, (Object)cloudConfig.isEnabled());
        Assert.assertEquals((Object)"EXAMPLE_TOKEN", (Object)cloudConfig.getDiscoveryToken());
    }

    @Test
    public void testCloudConfig_defaults() {
        ClientCloudConfig cloudConfig = this.defaultClientConfig.getNetworkConfig().getCloudConfig();
        Assert.assertEquals((Object)false, (Object)cloudConfig.isEnabled());
        Assert.assertEquals(null, (Object)cloudConfig.getDiscoveryToken());
    }

    @Test
    public void testDiscoveryStrategyConfig() {
        DiscoveryConfig discoveryConfig = this.fullClientConfig.getNetworkConfig().getDiscoveryConfig();
        Assert.assertEquals((Object)"DummyFilterClass", (Object)discoveryConfig.getNodeFilterClass());
        Collection discoveryStrategyConfigs = discoveryConfig.getDiscoveryStrategyConfigs();
        Assert.assertEquals((long)1L, (long)discoveryStrategyConfigs.size());
        DiscoveryStrategyConfig discoveryStrategyConfig = (DiscoveryStrategyConfig)discoveryStrategyConfigs.iterator().next();
        Assert.assertEquals((Object)"DummyDiscoveryStrategy1", (Object)discoveryStrategyConfig.getClassName());
        Map properties = discoveryStrategyConfig.getProperties();
        Assert.assertEquals((long)3L, (long)properties.size());
        Assert.assertEquals((Object)"foo", properties.get("key-string"));
        Assert.assertEquals((Object)"123", properties.get("key-int"));
        Assert.assertEquals((Object)"true", properties.get("key-boolean"));
    }

    protected EvictionPolicy getNearCacheEvictionPolicy(String mapName, ClientConfig clientConfig) {
        return clientConfig.getNearCacheConfig(mapName).getEvictionConfig().getEvictionPolicy();
    }

    @Test
    public void testGroupConfig() {
        GroupConfig groupConfig = this.fullClientConfig.getGroupConfig();
        Assert.assertEquals((Object)"dev", (Object)groupConfig.getName());
        Assert.assertEquals((Object)"dev-pass", (Object)groupConfig.getPassword());
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((long)6L, (long)this.fullClientConfig.getProperties().size());
        Assert.assertEquals((Object)"60000", (Object)this.fullClientConfig.getProperty("hazelcast.client.heartbeat.timeout"));
    }

    @Test
    public void testLabels() {
        Set labels = this.fullClientConfig.getLabels();
        Assert.assertEquals((long)2L, (long)labels.size());
        AbstractClientConfigBuilderTest.assertContains((Collection)labels, (Object)"admin");
        AbstractClientConfigBuilderTest.assertContains((Collection)labels, (Object)"foo");
    }

    @Test
    public void testInstanceName() {
        Assert.assertEquals((Object)"CLIENT_NAME", (Object)this.fullClientConfig.getInstanceName());
    }

    @Test
    public void testSecurityConfig() {
        ClientSecurityConfig securityConfig = this.fullClientConfig.getSecurityConfig();
        Assert.assertEquals((Object)"com.hazelcast.security.UsernamePasswordCredentials", (Object)securityConfig.getCredentialsClassname());
        CredentialsFactoryConfig credentialsFactoryConfig = securityConfig.getCredentialsFactoryConfig();
        Assert.assertEquals((Object)"com.hazelcast.examples.MyCredentialsFactory", (Object)credentialsFactoryConfig.getClassName());
        Properties properties = credentialsFactoryConfig.getProperties();
        Assert.assertEquals((Object)"value", (Object)properties.getProperty("property"));
    }

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testInvalidRootElement();

    @Test(expected=HazelcastException.class)
    public abstract void loadingThroughSystemProperty_nonExistingFile() throws IOException;

    @Test
    public abstract void loadingThroughSystemProperty_existingFile() throws IOException;

    @Test(expected=HazelcastException.class)
    public abstract void loadingThroughSystemProperty_nonExistingClasspathResource() throws IOException;

    @Test
    public abstract void loadingThroughSystemProperty_existingClasspathResource() throws IOException;

    @Test
    public abstract void testFlakeIdGeneratorConfig();

    @Test
    public abstract void testSecurityConfig_onlyFactory();

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testHazelcastClientTagAppearsTwice();

    @Test
    public abstract void testNearCacheInMemoryFormatNative_withKeysByReference();

    @Test
    public abstract void testNearCacheEvictionPolicy();

    @Test
    public abstract void testClientUserCodeDeploymentConfig();

    @Test
    public abstract void testReliableTopic_defaults();

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testQueryCacheBothPredicateDefinedThrows();

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testQueryCacheNoPredicateDefinedThrows();

    @Test
    public abstract void testLoadBalancerRandom();

    @Test
    public abstract void testLoadBalancerRoundRobin();
}

