/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.test.HazelcastTestSupport;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractClientConfigImportVariableReplacementTest
extends HazelcastTestSupport {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testImportElementOnlyAppersInTopLevel();

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testHazelcastElementOnlyAppearsOnce();

    @Test
    public abstract void readVariables();

    @Test
    public abstract void testImportConfigFromResourceVariables() throws IOException;

    @Test
    public abstract void testImportedConfigVariableReplacement() throws IOException;

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testTwoResourceCyclicImportThrowsException() throws Exception;

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testThreeResourceCyclicImportThrowsException() throws Exception;

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testImportEmptyResourceContent() throws Exception;

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testImportEmptyResourceThrowsException();

    @Test(expected=InvalidConfigurationException.class)
    public abstract void testImportNotExistingResourceThrowsException();

    @Test
    public abstract void testReplacers() throws Exception;

    @Test(expected=ConfigurationException.class)
    public abstract void testMissingReplacement();

    @Test
    public abstract void testReplacerProperties();

    @Test
    public abstract void testNoConfigReplacersMissingProperties();

    @Test
    public abstract void testImportGroupConfigFromClassPath();

    @Test
    public abstract void testReplaceVariablesUseSystemProperties() throws Exception;

    @Test
    public abstract void testReplaceVariablesWithClasspathConfig();

    protected static File createConfigFile(String filename, String suffix) throws IOException {
        File file = File.createTempFile(filename, suffix);
        file.setWritable(true);
        file.deleteOnExit();
        return file;
    }

    protected static void writeStringToStreamAndClose(FileOutputStream os, String string) throws IOException {
        os.write(string.getBytes());
        os.flush();
        IOUtil.closeResource((Closeable)os);
    }
}

