/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.core.HazelcastException;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

abstract class AbstractClientFailoverConfigBuilderTest {
    protected ClientFailoverConfig fullClientConfig;

    AbstractClientFailoverConfigBuilderTest() {
    }

    @After
    @Before
    public void beforeAndAfter() {
        System.clearProperty("hazelcast.client.failover.config");
    }

    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingFile() {
        System.setProperty("hazelcast.client.failover.config", "idontexist");
        this.buildConfig();
    }

    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingClasspathResource() {
        System.setProperty("hazelcast.client.failover.config", "classpath:idontexist");
        this.buildConfig();
    }

    @Test
    public abstract void loadingThroughSystemProperty_existingClasspathResource();

    @Test
    public void testClientFailoverConfig() {
        this.assertSampleFailoverConfig(this.fullClientConfig);
    }

    @Test
    public abstract void testVariableReplacementFromSystemProperties();

    @Test
    public abstract void testVariableReplacementFromProperties();

    @Test
    public abstract void testWithClasspathConfig();

    @Test
    public abstract void testVariableReplacementFromSystemPropertiesWithClasspathConfig();

    abstract ClientFailoverConfig buildConfig();

    void assertSampleFailoverConfig(ClientFailoverConfig config) {
        List clientConfigs = this.fullClientConfig.getClientConfigs();
        Assert.assertEquals((long)2L, (long)clientConfigs.size());
        Assert.assertEquals((Object)"cluster1", (Object)((ClientConfig)clientConfigs.get(0)).getGroupConfig().getName());
        Assert.assertEquals((Object)"cluster2", (Object)((ClientConfig)clientConfigs.get(1)).getGroupConfig().getName());
        Assert.assertEquals((long)4L, (long)config.getTryCount());
    }
}

