/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.test.PortableFactory;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientConfigTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testCopyConstructor_withFullyConfiguredClientConfig() throws IOException {
        URL schemaResource = ClientConfigTest.class.getClassLoader().getResource("hazelcast-client-full.xml");
        ClientConfig expected = new XmlClientConfigBuilder(schemaResource).build();
        ClientConfig actual = new ClientConfig(expected);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCopyConstructor_withDefaultClientConfig() {
        ClientConfig expected = new ClientConfig();
        ClientConfig actual = new ClientConfig(expected);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAccessGroupNameOverClientInstance() {
        Config config = new Config();
        String groupName = "aGroupName";
        config.getGroupConfig().setName(groupName);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setName(groupName);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        Assert.assertEquals((Object)groupName, (Object)client.getConfig().getGroupConfig().getName());
    }

    @Test
    public void testAccessSerializationConfigOverClientInstance() {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().addPortableFactory(666, (com.hazelcast.nio.serialization.PortableFactory)new PortableFactory());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        SerializationConfig serializationConfig = client.getConfig().getSerializationConfig();
        Map factories = serializationConfig.getPortableFactories();
        Assert.assertEquals((long)1L, (long)factories.size());
        Assert.assertEquals((long)((com.hazelcast.nio.serialization.PortableFactory)factories.get(666)).create(2).getClassId(), (long)2L);
    }

    @Test
    public void testUserContext_passContext() {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        ConcurrentHashMap<String, Object> context = new ConcurrentHashMap<String, Object>();
        context.put("key1", "value1");
        Object value2 = new Object();
        context.put("key2", value2);
        clientConfig = clientConfig.setUserContext(context);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        ConcurrentMap returnedContext = client.getUserContext();
        Assert.assertEquals(context, (Object)returnedContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUserContext_throwExceptionWhenContextNull() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setUserContext(null);
    }

    @Test
    public void testReliableTopic() {
        ClientConfig clientConfig = new ClientConfig();
        ClientReliableTopicConfig defaultReliableTopicConfig = new ClientReliableTopicConfig("default");
        defaultReliableTopicConfig.setReadBatchSize(100);
        clientConfig.addReliableTopicConfig(defaultReliableTopicConfig);
        ClientReliableTopicConfig newConfig = clientConfig.getReliableTopicConfig("newConfig");
        Assert.assertEquals((long)100L, (long)newConfig.getReadBatchSize());
    }
}

