/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConfigXmlGenerator;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
public class ClientConfigXmlGeneratorTest
extends HazelcastTestSupport {
    private static final boolean DEBUG = false;
    private static final Random RANDOM = new Random();
    private ClientConfig clientConfig = new ClientConfig();

    @Test
    public void escape() {
        String toEscape = "<>&\"'";
        GroupConfig groupConfig = new GroupConfig(toEscape, "pass");
        NearCacheConfig nearCacheConfig = new NearCacheConfig(toEscape);
        this.clientConfig.setGroupConfig(groupConfig).addNearCacheConfig(nearCacheConfig);
        ClientConfig actual = this.newConfigViaGenerator();
        Assert.assertEquals((Object)groupConfig.getName(), (Object)actual.getGroupConfig().getName());
        Assert.assertEquals((Object)toEscape, (Object)actual.getNearCacheConfig(toEscape).getName());
    }

    @Test
    public void instanceName() {
        String instanceName = ClientConfigXmlGeneratorTest.randomString();
        this.clientConfig.setInstanceName(instanceName);
        ClientConfig actual = this.newConfigViaGenerator();
        Assert.assertEquals((Object)instanceName, (Object)actual.getInstanceName());
    }

    @Test
    public void labels() {
        this.clientConfig.addLabel("foo");
        ClientConfig actual = this.newConfigViaGenerator();
        Set labels = actual.getLabels();
        Assert.assertEquals((long)1L, (long)labels.size());
        ClientConfigXmlGeneratorTest.assertContains((Collection)labels, (Object)"foo");
    }

    @Test
    public void group() {
        String name = ClientConfigXmlGeneratorTest.randomString();
        String pass = ClientConfigXmlGeneratorTest.randomString();
        GroupConfig expected = new GroupConfig(name, pass);
        this.clientConfig.setGroupConfig(expected);
        ClientConfig actual = this.newConfigViaGenerator();
        Assert.assertEquals((Object)name, (Object)actual.getGroupConfig().getName());
        Assert.assertEquals((Object)pass, (Object)actual.getGroupConfig().getPassword());
    }

    @Test
    public void nameAndProperties() {
        String name = ClientConfigXmlGeneratorTest.randomString();
        String property = ClientConfigXmlGeneratorTest.randomString();
        this.clientConfig.setInstanceName(name);
        this.clientConfig.setProperty("prop", property);
        ClientConfig actual = this.newConfigViaGenerator();
        Assert.assertEquals((Object)name, (Object)actual.getInstanceName());
        ClientConfigXmlGeneratorTest.assertProperties(this.clientConfig.getProperties(), actual.getProperties());
    }

    @Test
    public void network() {
        ClientNetworkConfig expected = new ClientNetworkConfig();
        expected.setSmartRouting(false).setRedoOperation(true).setConnectionTimeout(ClientConfigXmlGeneratorTest.randomInt()).setConnectionAttemptPeriod(ClientConfigXmlGeneratorTest.randomInt()).setConnectionAttemptLimit(ClientConfigXmlGeneratorTest.randomInt()).addAddress(new String[]{ClientConfigXmlGeneratorTest.randomString()}).setOutboundPortDefinitions(Collections.singleton(ClientConfigXmlGeneratorTest.randomString()));
        this.clientConfig.setNetworkConfig(expected);
        ClientNetworkConfig actual = this.newConfigViaGenerator().getNetworkConfig();
        Assert.assertFalse((boolean)actual.isSmartRouting());
        Assert.assertTrue((boolean)actual.isRedoOperation());
        Assert.assertEquals((long)expected.getConnectionTimeout(), (long)actual.getConnectionTimeout());
        Assert.assertEquals((long)expected.getConnectionAttemptPeriod(), (long)actual.getConnectionAttemptPeriod());
        Assert.assertEquals((long)expected.getConnectionAttemptLimit(), (long)actual.getConnectionAttemptLimit());
        ClientConfigXmlGeneratorTest.assertCollection(expected.getAddresses(), actual.getAddresses());
        ClientConfigXmlGeneratorTest.assertCollection(expected.getOutboundPortDefinitions(), actual.getOutboundPortDefinitions());
    }

    @Test
    public void networkSocketOptions() {
        SocketOptions expected = new SocketOptions();
        expected.setBufferSize(ClientConfigXmlGeneratorTest.randomInt()).setLingerSeconds(ClientConfigXmlGeneratorTest.randomInt()).setReuseAddress(false).setKeepAlive(false).setTcpNoDelay(false);
        this.clientConfig.getNetworkConfig().setSocketOptions(expected);
        SocketOptions actual = this.newConfigViaGenerator().getNetworkConfig().getSocketOptions();
        Assert.assertEquals((long)expected.getBufferSize(), (long)actual.getBufferSize());
        Assert.assertEquals((long)expected.getLingerSeconds(), (long)actual.getLingerSeconds());
        Assert.assertEquals((Object)expected.isReuseAddress(), (Object)actual.isReuseAddress());
        Assert.assertEquals((Object)expected.isKeepAlive(), (Object)actual.isKeepAlive());
        Assert.assertEquals((Object)expected.isTcpNoDelay(), (Object)actual.isTcpNoDelay());
    }

    @Test
    public void networkSocketInterceptor() {
        SocketInterceptorConfig expected = new SocketInterceptorConfig();
        expected.setEnabled(true).setClassName(ClientConfigXmlGeneratorTest.randomString()).setProperty("prop", ClientConfigXmlGeneratorTest.randomString());
        this.clientConfig.getNetworkConfig().setSocketInterceptorConfig(expected);
        SocketInterceptorConfig actual = this.newConfigViaGenerator().getNetworkConfig().getSocketInterceptorConfig();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void networkSsl() {
        SSLConfig expected = new SSLConfig();
        expected.setFactoryClassName(ClientConfigXmlGeneratorTest.randomString()).setEnabled(true).setProperty("prop", ClientConfigXmlGeneratorTest.randomString());
        this.clientConfig.getNetworkConfig().setSSLConfig(expected);
        SSLConfig actual = this.newConfigViaGenerator().getNetworkConfig().getSSLConfig();
        Assert.assertEquals((Object)expected.isEnabled(), (Object)actual.isEnabled());
        Assert.assertEquals((Object)expected.getFactoryClassName(), (Object)actual.getFactoryClassName());
        ClientConfigXmlGeneratorTest.assertProperties(expected.getProperties(), actual.getProperties());
    }

    @Test
    public void networkAws() {
        ClientAwsConfig expected = new ClientAwsConfig();
        expected.setInsideAws(true).setEnabled(true).setTagValue(ClientConfigXmlGeneratorTest.randomString()).setTagKey(ClientConfigXmlGeneratorTest.randomString()).setSecurityGroupName(ClientConfigXmlGeneratorTest.randomString()).setHostHeader(ClientConfigXmlGeneratorTest.randomString()).setRegion(ClientConfigXmlGeneratorTest.randomString()).setIamRole(ClientConfigXmlGeneratorTest.randomString()).setSecretKey(ClientConfigXmlGeneratorTest.randomString()).setAccessKey(ClientConfigXmlGeneratorTest.randomString()).setConnectionTimeoutSeconds(ClientConfigXmlGeneratorTest.randomInt());
        this.clientConfig.getNetworkConfig().setAwsConfig(expected);
        ClientAwsConfig actual = this.newConfigViaGenerator().getNetworkConfig().getAwsConfig();
        Assert.assertEquals((Object)expected.isInsideAws(), (Object)actual.isInsideAws());
        Assert.assertEquals((Object)expected.isEnabled(), (Object)actual.isEnabled());
        Assert.assertEquals((Object)expected.getTagValue(), (Object)actual.getTagValue());
        Assert.assertEquals((Object)expected.getTagKey(), (Object)actual.getTagKey());
        Assert.assertEquals((Object)expected.getSecurityGroupName(), (Object)actual.getSecurityGroupName());
        Assert.assertEquals((Object)expected.getHostHeader(), (Object)actual.getHostHeader());
        Assert.assertEquals((Object)expected.getRegion(), (Object)actual.getRegion());
        Assert.assertEquals((Object)expected.getIamRole(), (Object)actual.getIamRole());
        Assert.assertEquals((Object)expected.getSecretKey(), (Object)actual.getSecretKey());
        Assert.assertEquals((Object)expected.getAccessKey(), (Object)actual.getAccessKey());
        Assert.assertEquals((long)expected.getConnectionTimeoutSeconds(), (long)actual.getConnectionTimeoutSeconds());
    }

    @Test
    public void networkIcmp() {
        ClientIcmpPingConfig expected = new ClientIcmpPingConfig();
        expected.setEnabled(true).setEchoFailFastOnStartup(false).setIntervalMilliseconds(ClientConfigXmlGeneratorTest.randomInt()).setMaxAttempts(ClientConfigXmlGeneratorTest.randomInt()).setTimeoutMilliseconds(ClientConfigXmlGeneratorTest.randomInt()).setTtl(ClientConfigXmlGeneratorTest.randomInt());
        this.clientConfig.getNetworkConfig().setClientIcmpPingConfig(expected);
        ClientIcmpPingConfig actual = this.newConfigViaGenerator().getNetworkConfig().getClientIcmpPingConfig();
        Assert.assertEquals((Object)expected.isEnabled(), (Object)actual.isEnabled());
        Assert.assertEquals((Object)expected.isEchoFailFastOnStartup(), (Object)actual.isEchoFailFastOnStartup());
        Assert.assertEquals((long)expected.getIntervalMilliseconds(), (long)actual.getIntervalMilliseconds());
        Assert.assertEquals((long)expected.getMaxAttempts(), (long)actual.getMaxAttempts());
        Assert.assertEquals((long)expected.getTimeoutMilliseconds(), (long)actual.getTimeoutMilliseconds());
        Assert.assertEquals((long)expected.getTtl(), (long)actual.getTtl());
    }

    @Test
    public void discovery() {
        DiscoveryConfig expected = new DiscoveryConfig();
        expected.setNodeFilterClass(ClientConfigXmlGeneratorTest.randomString());
        DiscoveryStrategyConfig discoveryStrategy = new DiscoveryStrategyConfig(ClientConfigXmlGeneratorTest.randomString());
        discoveryStrategy.addProperty("prop", (Comparable)((Object)ClientConfigXmlGeneratorTest.randomString()));
        expected.addDiscoveryStrategyConfig(discoveryStrategy);
        this.clientConfig.getNetworkConfig().setDiscoveryConfig(expected);
        DiscoveryConfig actual = this.newConfigViaGenerator().getNetworkConfig().getDiscoveryConfig();
        Assert.assertEquals((Object)expected.getNodeFilterClass(), (Object)actual.getNodeFilterClass());
        ClientConfigXmlGeneratorTest.assertCollection(expected.getDiscoveryStrategyConfigs(), actual.getDiscoveryStrategyConfigs(), new Comparator<DiscoveryStrategyConfig>(){

            @Override
            public int compare(DiscoveryStrategyConfig o1, DiscoveryStrategyConfig o2) {
                ClientConfigXmlGeneratorTest.assertMap(o1.getProperties(), o2.getProperties());
                return o1.getClassName().equals(o2.getClassName()) ? 0 : -1;
            }
        });
    }

    @Test
    public void executorPoolSize() {
        this.clientConfig.setExecutorPoolSize(ClientConfigXmlGeneratorTest.randomInt());
        ClientConfig actual = this.newConfigViaGenerator();
        Assert.assertEquals((long)this.clientConfig.getExecutorPoolSize(), (long)actual.getExecutorPoolSize());
    }

    @Test
    public void security() {
        this.clientConfig.getSecurityConfig().setCredentialsClassname(ClientConfigXmlGeneratorTest.randomString());
        ClientConfig actual = this.newConfigViaGenerator();
        Assert.assertEquals((Object)this.clientConfig.getSecurityConfig().getCredentialsClassname(), (Object)actual.getSecurityConfig().getCredentialsClassname());
    }

    @Test
    public void listener() {
        ListenerConfig expected = new ListenerConfig(ClientConfigXmlGeneratorTest.randomString());
        this.clientConfig.addListenerConfig(expected);
        ClientConfig actual = this.newConfigViaGenerator();
        ClientConfigXmlGeneratorTest.assertCollection(this.clientConfig.getListenerConfigs(), actual.getListenerConfigs());
    }

    @Test
    public void serialization() {
        SerializationConfig expected = new SerializationConfig();
        expected.setPortableVersion(ClientConfigXmlGeneratorTest.randomInt()).setUseNativeByteOrder(true).setByteOrder(ByteOrder.LITTLE_ENDIAN).setEnableCompression(true).setEnableSharedObject(false).setAllowUnsafe(true).setCheckClassDefErrors(false).addDataSerializableFactoryClass(ClientConfigXmlGeneratorTest.randomInt(), ClientConfigXmlGeneratorTest.randomString()).addPortableFactoryClass(ClientConfigXmlGeneratorTest.randomInt(), ClientConfigXmlGeneratorTest.randomString()).setGlobalSerializerConfig(new GlobalSerializerConfig().setClassName(ClientConfigXmlGeneratorTest.randomString()).setOverrideJavaSerialization(true)).addSerializerConfig(new SerializerConfig().setClassName(ClientConfigXmlGeneratorTest.randomString()).setTypeClassName(ClientConfigXmlGeneratorTest.randomString()));
        this.clientConfig.setSerializationConfig(expected);
        SerializationConfig actual = this.newConfigViaGenerator().getSerializationConfig();
        Assert.assertEquals((long)expected.getPortableVersion(), (long)actual.getPortableVersion());
        Assert.assertEquals((Object)expected.isUseNativeByteOrder(), (Object)actual.isUseNativeByteOrder());
        Assert.assertEquals((Object)expected.getByteOrder(), (Object)actual.getByteOrder());
        Assert.assertEquals((Object)expected.isEnableCompression(), (Object)actual.isEnableCompression());
        Assert.assertEquals((Object)expected.isEnableSharedObject(), (Object)actual.isEnableSharedObject());
        Assert.assertEquals((Object)expected.isAllowUnsafe(), (Object)actual.isAllowUnsafe());
        Assert.assertEquals((Object)expected.isCheckClassDefErrors(), (Object)actual.isCheckClassDefErrors());
        Assert.assertEquals((Object)expected.getGlobalSerializerConfig(), (Object)actual.getGlobalSerializerConfig());
        ClientConfigXmlGeneratorTest.assertCollection(expected.getSerializerConfigs(), actual.getSerializerConfigs());
        ClientConfigXmlGeneratorTest.assertMap(expected.getDataSerializableFactoryClasses(), actual.getDataSerializableFactoryClasses());
        ClientConfigXmlGeneratorTest.assertMap(expected.getPortableFactoryClasses(), actual.getPortableFactoryClasses());
    }

    @Test
    public void nativeMemory() {
        NativeMemoryConfig expected = new NativeMemoryConfig();
        expected.setEnabled(true).setAllocatorType(NativeMemoryConfig.MemoryAllocatorType.STANDARD).setMetadataSpacePercentage(70.0f).setMinBlockSize(ClientConfigXmlGeneratorTest.randomInt()).setPageSize(ClientConfigXmlGeneratorTest.randomInt()).setSize(new MemorySize((long)ClientConfigXmlGeneratorTest.randomInt(), MemoryUnit.BYTES));
        this.clientConfig.setNativeMemoryConfig(expected);
        NativeMemoryConfig actual = this.newConfigViaGenerator().getNativeMemoryConfig();
        Assert.assertEquals((Object)this.clientConfig.getNativeMemoryConfig(), (Object)actual);
    }

    @Test
    public void proxyFactory() {
        ProxyFactoryConfig expected = new ProxyFactoryConfig();
        expected.setClassName(ClientConfigXmlGeneratorTest.randomString()).setService(ClientConfigXmlGeneratorTest.randomString());
        this.clientConfig.addProxyFactoryConfig(expected);
        List actual = this.newConfigViaGenerator().getProxyFactoryConfigs();
        ClientConfigXmlGeneratorTest.assertCollection(this.clientConfig.getProxyFactoryConfigs(), actual);
    }

    @Test
    public void loadBalancer() {
        this.clientConfig.setLoadBalancer((LoadBalancer)new RandomLB());
        LoadBalancer actual = this.newConfigViaGenerator().getLoadBalancer();
        Assert.assertTrue((boolean)(actual instanceof RandomLB));
    }

    @Test
    public void nearCache() {
        NearCacheConfig expected = new NearCacheConfig();
        expected.setInMemoryFormat(InMemoryFormat.NATIVE).setSerializeKeys(true).setInvalidateOnChange(false).setCacheLocalEntries(true).setTimeToLiveSeconds(ClientConfigXmlGeneratorTest.randomInt()).setMaxIdleSeconds(ClientConfigXmlGeneratorTest.randomInt()).setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE).setName(ClientConfigXmlGeneratorTest.randomString()).setPreloaderConfig(new NearCachePreloaderConfig().setEnabled(true).setDirectory(ClientConfigXmlGeneratorTest.randomString()).setStoreInitialDelaySeconds(ClientConfigXmlGeneratorTest.randomInt()).setStoreIntervalSeconds(ClientConfigXmlGeneratorTest.randomInt())).setEvictionConfig(new EvictionConfig().setEvictionPolicy(EvictionPolicy.LFU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.USED_NATIVE_MEMORY_SIZE).setSize(ClientConfigXmlGeneratorTest.randomInt()));
        this.clientConfig.addNearCacheConfig(expected);
        Map actual = this.newConfigViaGenerator().getNearCacheConfigMap();
        ClientConfigXmlGeneratorTest.assertMap(this.clientConfig.getNearCacheConfigMap(), actual);
    }

    @Test
    public void queryCache() {
        QueryCacheConfig expected = new QueryCacheConfig();
        expected.setBufferSize(ClientConfigXmlGeneratorTest.randomInt()).setInMemoryFormat(InMemoryFormat.OBJECT).setName(ClientConfigXmlGeneratorTest.randomString()).setBatchSize(ClientConfigXmlGeneratorTest.randomInt()).setCoalesce(true).setDelaySeconds(ClientConfigXmlGeneratorTest.randomInt()).setIncludeValue(false).setPopulate(false).setPredicateConfig(new PredicateConfig(ClientConfigXmlGeneratorTest.randomString())).setEvictionConfig(new EvictionConfig().setEvictionPolicy(EvictionPolicy.LFU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.USED_NATIVE_MEMORY_SIZE).setSize(ClientConfigXmlGeneratorTest.randomInt())).addIndexConfig(new MapIndexConfig().setOrdered(true).setAttribute(ClientConfigXmlGeneratorTest.randomString())).addEntryListenerConfig((EntryListenerConfig)new EntryListenerConfig().setIncludeValue(true).setLocal(true).setClassName(ClientConfigXmlGeneratorTest.randomString()));
        this.clientConfig.addQueryCacheConfig(ClientConfigXmlGeneratorTest.randomString(), expected);
        Map actual = this.newConfigViaGenerator().getQueryCacheConfigs();
        ClientConfigXmlGeneratorTest.assertMap(this.clientConfig.getQueryCacheConfigs(), actual);
    }

    @Test
    public void connectionStrategy() {
        ClientConnectionStrategyConfig expected = new ClientConnectionStrategyConfig();
        expected.setAsyncStart(true).setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        this.clientConfig.setConnectionStrategyConfig(expected);
        ClientConnectionStrategyConfig actual = this.newConfigViaGenerator().getConnectionStrategyConfig();
        Assert.assertEquals((Object)expected.isAsyncStart(), (Object)actual.isAsyncStart());
        Assert.assertEquals((Object)expected.getReconnectMode(), (Object)actual.getReconnectMode());
    }

    @Test
    public void userCodeDeployment() {
        ClientUserCodeDeploymentConfig expected = new ClientUserCodeDeploymentConfig();
        expected.setEnabled(true).addClass(ClientConfigXmlGeneratorTest.randomString()).addJar(ClientConfigXmlGeneratorTest.randomString());
        this.clientConfig.setUserCodeDeploymentConfig(expected);
        ClientUserCodeDeploymentConfig actual = this.newConfigViaGenerator().getUserCodeDeploymentConfig();
        Assert.assertEquals((Object)expected.isEnabled(), (Object)actual.isEnabled());
        ClientConfigXmlGeneratorTest.assertCollection(expected.getClassNames(), actual.getClassNames());
        ClientConfigXmlGeneratorTest.assertCollection(expected.getJarPaths(), actual.getJarPaths());
    }

    @Test
    public void flakeIdGenerator() {
        ClientFlakeIdGeneratorConfig expected = new ClientFlakeIdGeneratorConfig(ClientConfigXmlGeneratorTest.randomString());
        expected.setPrefetchCount(ClientConfigXmlGeneratorTest.randomInt()).setPrefetchValidityMillis((long)ClientConfigXmlGeneratorTest.randomInt());
        this.clientConfig.addFlakeIdGeneratorConfig(expected);
        Map actual = this.newConfigViaGenerator().getFlakeIdGeneratorConfigMap();
        ClientConfigXmlGeneratorTest.assertMap(this.clientConfig.getFlakeIdGeneratorConfigMap(), actual);
    }

    private ClientConfig newConfigViaGenerator() {
        String xml = ClientConfigXmlGenerator.generate((ClientConfig)this.clientConfig, (int)-1);
        ClientConfigXmlGeneratorTest.debug(xml);
        return new XmlClientConfigBuilder((InputStream)new ByteArrayInputStream(xml.getBytes())).build();
    }

    private static int randomInt() {
        return ClientConfigXmlGeneratorTest.randomInt(1000);
    }

    private static int randomInt(int bound) {
        return RANDOM.nextInt(bound) + 1;
    }

    private static <T> void assertCollection(Collection<T> expected, Collection<T> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        ClientConfigXmlGeneratorTest.assertContainsAll(actual, expected);
    }

    private static <T> void assertCollection(Collection<T> expected, Collection<T> actual, Comparator<T> comparator) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (T item : expected) {
            if (!ClientConfigXmlGeneratorTest.contains(item, actual, comparator)) {
                throw new AssertionError((Object)("Actual collection does not contain the item " + item));
            }
        }
    }

    private static <T> boolean contains(T item1, Collection<T> collection, Comparator<T> comparator) {
        for (T item2 : collection) {
            if (comparator.compare(item1, item2) != 0) continue;
            return true;
        }
        return false;
    }

    private static <K, V> void assertMap(Map<K, V> expected, Map<K, V> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        ClientConfigXmlGeneratorTest.assertContainsAll(actual.entrySet(), expected.entrySet());
    }

    private static void assertProperties(Properties expected, Properties actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Set<String> names = expected.stringPropertyNames();
        for (String name : names) {
            Assert.assertEquals((Object)expected.getProperty(name), (Object)actual.getProperty(name));
        }
    }

    private static void debug(String s) {
    }
}

