/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.helpers.DeclarativeConfigFileHelper;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class XmlClientConfigBuilderResolutionTest {
    private static final String SYSPROP_NAME = "hazelcast.client.config";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final DeclarativeConfigFileHelper helper = new DeclarativeConfigFileHelper();

    @Before
    @After
    public void beforeAndAfter() throws Exception {
        System.clearProperty(SYSPROP_NAME);
        this.helper.ensureTestConfigDeleted();
    }

    @Test
    public void testResolveSystemProperty_file_xml() throws Exception {
        this.helper.givenXmlClientConfigFileInWorkDir("foo.xml", "cluster-xml-file");
        System.setProperty(SYSPROP_NAME, "foo.xml");
        ClientConfig config = new XmlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-xml-file", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_xml() throws Exception {
        this.helper.givenXmlClientConfigFileOnClasspath("foo.xml", "cluster-xml-classpath");
        System.setProperty(SYSPROP_NAME, "classpath:foo.xml");
        ClientConfig config = new XmlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-xml-classpath", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentXml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:idontexist.xml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("idontexist.xml");
        new XmlClientConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentXml_throws() {
        System.setProperty(SYSPROP_NAME, "idontexist.xml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("idontexist.xml");
        new XmlClientConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonXml_loadedAsXml() throws Exception {
        File file = this.helper.givenXmlClientConfigFileInWorkDir("foo.bar", "cluster-bar-file");
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        ClientConfig config = new XmlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-bar-file", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_nonXml_loadedAsXml() throws Exception {
        this.helper.givenXmlClientConfigFileOnClasspath("foo.bar", "cluster-bar-classpath");
        System.setProperty(SYSPROP_NAME, "classpath:foo.bar");
        ClientConfig config = new XmlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-bar-classpath", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentNonXml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:idontexist.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("idontexist.bar");
        new XmlClientConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentNonXml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.bar");
        new XmlClientConfigBuilder().build();
    }

    @Test
    public void testResolveFromWorkDir() throws Exception {
        this.helper.givenXmlClientConfigFileInWorkDir("cluster-xml-workdir");
        ClientConfig config = new XmlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-xml-workdir", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveFromClasspath() throws Exception {
        this.helper.givenXmlClientConfigFileOnClasspath("cluster-xml-classpath");
        ClientConfig config = new XmlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-xml-classpath", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveDefault() {
        ClientConfig config = new XmlClientConfigBuilder().build();
        Assert.assertEquals((Object)"dev", (Object)config.getGroupConfig().getName());
    }
}

