/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.AbstractClientConfigBuilderTest;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.XMLConfigBuilderTest;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.TopicOverloadPolicy;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.xml.sax.SAXException;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class XmlClientConfigBuilderTest
extends AbstractClientConfigBuilderTest {
    static final String HAZELCAST_CLIENT_START_TAG = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n";
    static final String HAZELCAST_CLIENT_END_TAG = "</hazelcast-client>";

    @Before
    public void init() throws Exception {
        URL schemaResource = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-full.xml");
        this.fullClientConfig = new XmlClientConfigBuilder(schemaResource).build();
        URL schemaResourceDefault = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-default.xml");
        this.defaultClientConfig = new XmlClientConfigBuilder(schemaResourceDefault).build();
    }

    @After
    @Before
    public void beforeAndAfter() {
        System.clearProperty("hazelcast.client.config");
    }

    @Override
    @Test(expected=InvalidConfigurationException.class)
    public void testInvalidRootElement() {
        String xml = "<hazelcast><group><name>dev</name><password>clusterpass</password></group></hazelcast>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Override
    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingFile() throws IOException {
        File file = File.createTempFile("foo", ".xml");
        IOUtil.delete((File)file);
        System.setProperty("hazelcast.client.config", file.getAbsolutePath());
        new XmlClientConfigBuilder();
    }

    @Override
    @Test
    public void loadingThroughSystemProperty_existingFile() throws IOException {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <group>\n        <name>foobar</name>\n        <password>dev-pass</password>\n    </group>\n</hazelcast-client>";
        File file = File.createTempFile("foo", ".xml");
        file.deleteOnExit();
        PrintWriter writer = new PrintWriter(file, "UTF-8");
        writer.println(xml);
        writer.close();
        System.setProperty("hazelcast.client.config", file.getAbsolutePath());
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder();
        ClientConfig config = configBuilder.build();
        Assert.assertEquals((Object)"foobar", (Object)config.getGroupConfig().getName());
    }

    @Override
    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingClasspathResource() throws IOException {
        System.setProperty("hazelcast.client.config", "classpath:idontexist.xml");
        new XmlClientConfigBuilder();
    }

    @Override
    @Test
    public void loadingThroughSystemProperty_existingClasspathResource() throws IOException {
        System.setProperty("hazelcast.client.config", "classpath:test-hazelcast-client.xml");
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder();
        ClientConfig config = configBuilder.build();
        Assert.assertEquals((Object)"foobar-xml", (Object)config.getGroupConfig().getName());
        Assert.assertEquals((Object)"com.hazelcast.nio.ssl.BasicSSLContextFactory", (Object)config.getNetworkConfig().getSSLConfig().getFactoryClassName());
        Assert.assertEquals((long)128L, (long)config.getNetworkConfig().getSocketOptions().getBufferSize());
        Assert.assertFalse((boolean)config.getNetworkConfig().getSocketOptions().isKeepAlive());
        Assert.assertFalse((boolean)config.getNetworkConfig().getSocketOptions().isTcpNoDelay());
        Assert.assertEquals((long)3L, (long)config.getNetworkConfig().getSocketOptions().getLingerSeconds());
    }

    @Override
    @Test
    public void testFlakeIdGeneratorConfig() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<flake-id-generator name='gen'>  <prefetch-count>3</prefetch-count>  <prefetch-validity-millis>10</prefetch-validity-millis></flake-id-generator></hazelcast-client>";
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml);
        ClientFlakeIdGeneratorConfig fConfig = config.findFlakeIdGeneratorConfig("gen");
        Assert.assertEquals((Object)"gen", (Object)fConfig.getName());
        Assert.assertEquals((long)3L, (long)fConfig.getPrefetchCount());
        Assert.assertEquals((long)10L, (long)fConfig.getPrefetchValidityMillis());
    }

    @Override
    @Test
    public void testSecurityConfig_onlyFactory() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n  <security>\n        <credentials-factory class-name=\"com.hazelcast.examples.MyCredentialsFactory\">\n            <properties>\n                <property name=\"property\">value</property>\n            </properties>\n        </credentials-factory>\n    </security></hazelcast-client>";
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml);
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        CredentialsFactoryConfig credentialsFactoryConfig = securityConfig.getCredentialsFactoryConfig();
        Assert.assertEquals((Object)"com.hazelcast.examples.MyCredentialsFactory", (Object)credentialsFactoryConfig.getClassName());
        Properties properties = credentialsFactoryConfig.getProperties();
        Assert.assertEquals((Object)"value", (Object)properties.getProperty("property"));
    }

    @Test
    public void testXSDDefaultXML() throws SAXException, IOException {
        this.testXSDConfigXML("hazelcast-client-default.xml");
    }

    @Test
    public void testFullConfigXML() throws SAXException, IOException {
        this.testXSDConfigXML("hazelcast-client-full.xml");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testMissingNamespace() {
        String xml = "<hazelcast-client/>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testInvalidNamespace() {
        String xml = "<hazelcast-client xmlns=\"http://foo.bar\"/>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test
    public void testValidNamespace() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n</hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Override
    @Test(expected=InvalidConfigurationException.class)
    public void testHazelcastClientTagAppearsTwice() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<hazelcast-client/><hazelcast-client/>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Override
    @Test
    public void testNearCacheInMemoryFormatNative_withKeysByReference() {
        String mapName = "testMapNearCacheInMemoryFormatNative";
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n  <near-cache name=\"" + mapName + "\">\n    <in-memory-format>NATIVE</in-memory-format>\n    <serialize-keys>false</serialize-keys>\n  </near-cache>\n" + HAZELCAST_CLIENT_END_TAG;
        ClientConfig clientConfig = XmlClientConfigBuilderTest.buildConfig(xml);
        NearCacheConfig ncConfig = clientConfig.getNearCacheConfig(mapName);
        Assert.assertEquals((Object)InMemoryFormat.NATIVE, (Object)ncConfig.getInMemoryFormat());
        Assert.assertTrue((boolean)ncConfig.isSerializeKeys());
    }

    @Override
    @Test
    public void testNearCacheEvictionPolicy() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<near-cache name=\"lfu\">  <eviction eviction-policy=\"LFU\"/></near-cache><near-cache name=\"lru\">  <eviction eviction-policy=\"LRU\"/></near-cache><near-cache name=\"none\">  <eviction eviction-policy=\"NONE\"/></near-cache><near-cache name=\"random\">  <eviction eviction-policy=\"RANDOM\"/></near-cache></hazelcast-client>";
        ClientConfig clientConfig = XmlClientConfigBuilderTest.buildConfig(xml);
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)this.getNearCacheEvictionPolicy("lfu", clientConfig));
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)this.getNearCacheEvictionPolicy("lru", clientConfig));
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)this.getNearCacheEvictionPolicy("none", clientConfig));
        Assert.assertEquals((Object)EvictionPolicy.RANDOM, (Object)this.getNearCacheEvictionPolicy("random", clientConfig));
    }

    @Override
    @Test
    public void testClientUserCodeDeploymentConfig() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<user-code-deployment enabled=\"true\">\n        <jarPaths>\n            <jarPath>/User/test/test.jar</jarPath>\n        </jarPaths>\n        <classNames>\n            <className>test.testClassName</className>\n            <className>test.testClassName2</className>\n        </classNames>\n    </user-code-deployment></hazelcast-client>";
        ClientConfig clientConfig = XmlClientConfigBuilderTest.buildConfig(xml);
        ClientUserCodeDeploymentConfig userCodeDeploymentConfig = clientConfig.getUserCodeDeploymentConfig();
        Assert.assertTrue((boolean)userCodeDeploymentConfig.isEnabled());
        List classNames = userCodeDeploymentConfig.getClassNames();
        Assert.assertEquals((long)2L, (long)classNames.size());
        Assert.assertTrue((boolean)classNames.contains("test.testClassName"));
        Assert.assertTrue((boolean)classNames.contains("test.testClassName2"));
        List jarPaths = userCodeDeploymentConfig.getJarPaths();
        Assert.assertEquals((long)1L, (long)jarPaths.size());
        Assert.assertTrue((boolean)jarPaths.contains("/User/test/test.jar"));
    }

    @Override
    @Test
    public void testReliableTopic_defaults() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<reliable-topic name=\"rel-topic\"></reliable-topic></hazelcast-client>";
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml);
        ClientReliableTopicConfig reliableTopicConfig = config.getReliableTopicConfig("rel-topic");
        Assert.assertEquals((Object)"rel-topic", (Object)reliableTopicConfig.getName());
        Assert.assertEquals((long)10L, (long)reliableTopicConfig.getReadBatchSize());
        Assert.assertEquals((Object)TopicOverloadPolicy.BLOCK, (Object)reliableTopicConfig.getTopicOverloadPolicy());
    }

    @Override
    @Test(expected=InvalidConfigurationException.class)
    public void testQueryCacheBothPredicateDefinedThrows() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<query-caches>  <query-cache name=\"cache-name\" mapName=\"map-name\">    <predicate type=\"class-name\">com.hazelcast.example.Predicate</predicate>    <predicate type=\"sql\">%age=40</predicate>  </query-cache></query-caches></hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Override
    @Test(expected=InvalidConfigurationException.class)
    public void testQueryCacheNoPredicateDefinedThrows() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<query-caches>  <query-cache name=\"cache-name\" mapName=\"map-name\">  </query-cache></query-caches></hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Override
    public void testLoadBalancerRandom() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<load-balancer type=\"random\" /></hazelcast-client>";
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml);
        XmlClientConfigBuilderTest.assertInstanceOf(RandomLB.class, (Object)config.getLoadBalancer());
    }

    @Override
    public void testLoadBalancerRoundRobin() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<load-balancer type=\"round-robin\" /></hazelcast-client>";
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml);
        XmlClientConfigBuilderTest.assertInstanceOf(RoundRobinLB.class, (Object)config.getLoadBalancer());
    }

    static ClientConfig buildConfig(String xml, Properties properties) {
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder((InputStream)bis);
        if (properties != null) {
            configBuilder.setProperties(properties);
        }
        return configBuilder.build();
    }

    static ClientConfig buildConfig(String xml, String key, String value) {
        Properties properties = new Properties();
        properties.setProperty(key, value);
        return XmlClientConfigBuilderTest.buildConfig(xml, properties);
    }

    public static ClientConfig buildConfig(String xml) {
        return XmlClientConfigBuilderTest.buildConfig(xml, null);
    }

    private void testXSDConfigXML(String xmlFileName) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaResource = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-config-" + Versions.CURRENT_CLUSTER_VERSION + ".xsd");
        InputStream xmlResource = XMLConfigBuilderTest.class.getClassLoader().getResourceAsStream(xmlFileName);
        Schema schema = factory.newSchema(schemaResource);
        StreamSource source = new StreamSource(xmlResource);
        Validator validator = schema.newValidator();
        try {
            validator.validate(source);
        }
        catch (SAXException ex) {
            Assert.fail((String)(xmlFileName + " is not valid because: " + ex.toString()));
        }
    }
}

