/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.XmlClientFailoverConfigBuilder;
import com.hazelcast.config.helpers.DeclarativeConfigFileHelper;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class XmlClientFailoverConfigBuilderConfigResolutionTest {
    private static final String SYSPROP_NAME = "hazelcast.client.failover.config";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final DeclarativeConfigFileHelper helper = new DeclarativeConfigFileHelper();

    @Before
    @After
    public void beforeAndAfter() throws IOException {
        System.clearProperty(SYSPROP_NAME);
        this.helper.ensureTestConfigDeleted();
    }

    @Test
    public void testResolveSystemProperty_file_xml() throws Exception {
        this.helper.givenXmlClientFailoverConfigFileInWorkDir("foo.xml", 42);
        System.setProperty(SYSPROP_NAME, "foo.xml");
        ClientFailoverConfig config = new XmlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_xml() throws Exception {
        this.helper.givenXmlClientFailoverConfigFileOnClasspath("foo.xml", 42);
        System.setProperty(SYSPROP_NAME, "classpath:foo.xml");
        ClientFailoverConfig config = new XmlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentXml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:idontexist.xml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("idontexist.xml");
        new XmlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentXml_throws() {
        System.setProperty(SYSPROP_NAME, "idontexist.xml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("idontexist.xml");
        new XmlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonXml_loadedAsXml() throws Exception {
        File file = this.helper.givenXmlClientFailoverConfigFileInWorkDir("foo.bar", 42);
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        ClientFailoverConfig config = new XmlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_nonXml_loadedAsXml() throws Exception {
        this.helper.givenXmlClientFailoverConfigFileOnClasspath("foo.bar", 42);
        System.setProperty(SYSPROP_NAME, "classpath:foo.bar");
        ClientFailoverConfig config = new XmlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentNonXml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:idontexist.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("idontexist.bar");
        new XmlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentNonXml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.bar");
        new XmlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveFromWorkDir() throws Exception {
        this.helper.givenXmlClientFailoverConfigFileInWorkDir(42);
        ClientFailoverConfig config = new XmlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveFromClasspath() throws Exception {
        this.helper.givenXmlClientFailoverConfigFileOnClasspath(42);
        ClientFailoverConfig config = new XmlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveDefault() {
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("Failed to load ClientFailoverConfig");
        new XmlClientFailoverConfigBuilder().build();
    }
}

