/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.AbstractClientFailoverConfigBuilderTest;
import com.hazelcast.client.config.ClientFailoverClasspathXmlConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.XmlClientFailoverConfigBuilder;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class XmlClientFailoverConfigBuilderTest
extends AbstractClientFailoverConfigBuilderTest {
    private static final String HAZELCAST_CLIENT_FAILOVER_START_TAG = "<hazelcast-client-failover xmlns=\"http://www.hazelcast.com/schema/client-config\">\n";
    private static final String HAZELCAST_CLIENT_FAILOVER_END_TAG = "</hazelcast-client-failover>";

    @Before
    public void init() throws Exception {
        URL schemaResource = XmlClientFailoverConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-failover-sample.xml");
        this.fullClientConfig = new XmlClientFailoverConfigBuilder(schemaResource).build();
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testInvalidRootElement() {
        String xml = "<hazelcast><group><name>dev</name><password>clusterpass</password></group></hazelcast>";
        XmlClientFailoverConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testExpectsAtLeastOneConfig() {
        String xml = "<hazelcast-client-failover>    <clients>    </clients></hazelcast-client-failover>";
        Properties properties = new Properties();
        properties.setProperty("try-count", "11");
        ClientFailoverConfig config = XmlClientFailoverConfigBuilderTest.buildConfig(xml, properties);
        Assert.assertEquals((long)11L, (long)config.getTryCount());
    }

    @Override
    @Test
    public void testVariableReplacementFromProperties() {
        String xml = "<hazelcast-client-failover xmlns=\"http://www.hazelcast.com/schema/client-config\">\n  <clients>    <client>hazelcast-client-c1.xml</client>\n    <client>hazelcast-client-c2.xml</client>\n  </clients>  <try-count>${try-count}</try-count></hazelcast-client-failover>";
        Properties properties = new Properties();
        properties.setProperty("try-count", "11");
        ClientFailoverConfig config = XmlClientFailoverConfigBuilderTest.buildConfig(xml, properties);
        Assert.assertEquals((long)11L, (long)config.getTryCount());
    }

    @Override
    @Test
    public void testVariableReplacementFromSystemProperties() {
        String xml = "<hazelcast-client-failover xmlns=\"http://www.hazelcast.com/schema/client-config\">\n  <clients>    <client>hazelcast-client-c1.xml</client>\n    <client>hazelcast-client-c2.xml</client>\n  </clients>  <try-count>${try-count}</try-count></hazelcast-client-failover>";
        System.setProperty("try-count", "11");
        ClientFailoverConfig config = XmlClientFailoverConfigBuilderTest.buildConfig(xml);
        Assert.assertEquals((long)11L, (long)config.getTryCount());
    }

    @Override
    @Test
    public void testWithClasspathConfig() {
        ClientFailoverClasspathXmlConfig config = new ClientFailoverClasspathXmlConfig("hazelcast-client-failover-sample.xml");
        this.assertSampleFailoverConfig((ClientFailoverConfig)config);
    }

    @Override
    @Test
    public void testVariableReplacementFromSystemPropertiesWithClasspathConfig() {
        System.setProperty("try-count", "13");
        ClientFailoverClasspathXmlConfig config = new ClientFailoverClasspathXmlConfig("hazelcast-client-failover-sample-with-variable.xml");
        Assert.assertEquals((long)13L, (long)config.getTryCount());
    }

    @Override
    @Test
    public void loadingThroughSystemProperty_existingClasspathResource() {
        System.setProperty("hazelcast.client.failover.config", "classpath:hazelcast-client-failover-sample.xml");
        ClientFailoverConfig config = this.buildConfig();
        this.assertSampleFailoverConfig(config);
    }

    @Override
    ClientFailoverConfig buildConfig() {
        return new XmlClientFailoverConfigBuilder().build();
    }

    private static ClientFailoverConfig buildConfig(String yaml) {
        return XmlClientFailoverConfigBuilderTest.buildConfig(yaml, null);
    }

    private static ClientFailoverConfig buildConfig(String xml, Properties properties) {
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
        XmlClientFailoverConfigBuilder configBuilder = new XmlClientFailoverConfigBuilder((InputStream)bis);
        if (properties != null) {
            configBuilder.setProperties(properties);
        }
        return configBuilder.build();
    }
}

