/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientClasspathXmlConfig;
import com.hazelcast.client.config.ClientClasspathYamlConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConfigXmlGenerator;
import com.hazelcast.client.config.ClientFailoverClasspathXmlConfig;
import com.hazelcast.client.config.ClientFailoverClasspathYamlConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.config.helpers.DeclarativeConfigFileHelper;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class XmlYamlClientConfigBuilderEqualsTest {
    @Before
    public void assumeRunningOnJdk8() {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
    }

    @Test
    public void testDefaultClientConfig() {
        ClientClasspathXmlConfig xmlConfig = new ClientClasspathXmlConfig("hazelcast-client-default.xml");
        ClientClasspathYamlConfig yamlConfig = new ClientClasspathYamlConfig("hazelcast-client-default.yaml");
        String xmlConfigFromXml = ClientConfigXmlGenerator.generate((ClientConfig)xmlConfig);
        String xmlConfigFromYaml = ClientConfigXmlGenerator.generate((ClientConfig)yamlConfig);
        Assert.assertEquals((Object)xmlConfigFromXml, (Object)xmlConfigFromYaml);
    }

    @Test
    public void testFullClientConfig() throws IOException {
        String fullExampleXml = this.readResourceToString("hazelcast-client-full-example.xml");
        String fullExampleYaml = this.readResourceToString("hazelcast-client-full-example.yaml");
        fullExampleXml = fullExampleXml.replace("<import resource=\"your-client-configuration-XML-file\"/>", "");
        fullExampleYaml = fullExampleYaml.replace("\r", "").replace("import:\n    - your-client-configuration-YAML-file", "");
        ClientConfig xmlConfig = XmlYamlClientConfigBuilderEqualsTest.buildConfigFromXml(fullExampleXml);
        ClientConfig yamlConfig = XmlYamlClientConfigBuilderEqualsTest.buildConfigFromYaml(fullExampleYaml);
        String xmlConfigFromXml = ClientConfigXmlGenerator.generate((ClientConfig)xmlConfig, (int)4);
        String xmlConfigFromYaml = ClientConfigXmlGenerator.generate((ClientConfig)yamlConfig, (int)4);
        Assert.assertEquals((Object)xmlConfigFromXml, (Object)xmlConfigFromYaml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullClientFailoverConfig() throws Exception {
        DeclarativeConfigFileHelper helper = new DeclarativeConfigFileHelper();
        helper.givenXmlClientConfigFileOnClasspath("your-first-hazelcast-client-configuration.xml", "instance0");
        helper.givenXmlClientConfigFileOnClasspath("your-second-hazelcast-client-configuration.xml", "instance1");
        helper.givenYamlClientConfigFileOnClasspath("your-first-hazelcast-client-configuration.yaml", "instance0");
        helper.givenYamlClientConfigFileOnClasspath("your-second-hazelcast-client-configuration.yaml", "instance1");
        try {
            ClientFailoverClasspathXmlConfig xmlConfig = new ClientFailoverClasspathXmlConfig("hazelcast-client-failover-full-example.xml");
            ClientFailoverClasspathYamlConfig yamlConfig = new ClientFailoverClasspathYamlConfig("hazelcast-client-failover-full-example.yaml");
            Assert.assertEquals((long)xmlConfig.getTryCount(), (long)yamlConfig.getTryCount());
            ClientConfig xmlClientConfig0 = (ClientConfig)xmlConfig.getClientConfigs().get(0);
            ClientConfig xmlClientConfig1 = (ClientConfig)xmlConfig.getClientConfigs().get(1);
            ClientConfig yamlClientConfig0 = (ClientConfig)yamlConfig.getClientConfigs().get(0);
            ClientConfig yamlClientConfig1 = (ClientConfig)yamlConfig.getClientConfigs().get(1);
            Assert.assertEquals((Object)"instance0", (Object)xmlClientConfig0.getInstanceName());
            Assert.assertEquals((Object)"instance1", (Object)xmlClientConfig1.getInstanceName());
            Assert.assertEquals((Object)"instance0", (Object)yamlClientConfig0.getInstanceName());
            Assert.assertEquals((Object)"instance1", (Object)yamlClientConfig1.getInstanceName());
        }
        finally {
            helper.ensureTestConfigDeleted();
        }
    }

    private String readResourceToString(String resource) throws IOException {
        InputStream xmlInputStream = this.getClass().getClassLoader().getResourceAsStream(resource);
        return new String(IOUtil.toByteArray((InputStream)xmlInputStream));
    }

    private static ClientConfig buildConfigFromXml(String xml) {
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
        return new XmlClientConfigBuilder((InputStream)bis).build();
    }

    private static ClientConfig buildConfigFromYaml(String yaml) {
        ByteArrayInputStream bis = new ByteArrayInputStream(yaml.getBytes());
        return new YamlClientConfigBuilder((InputStream)bis).build();
    }
}

