/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.config.helpers.DeclarativeConfigFileHelper;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class YamlClientConfigBuilderResolutionTest {
    private static final String SYSPROP_NAME = "hazelcast.client.config";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private DeclarativeConfigFileHelper helper = new DeclarativeConfigFileHelper();

    @Before
    public void setUp() {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        System.clearProperty(SYSPROP_NAME);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty(SYSPROP_NAME);
        this.helper.ensureTestConfigDeleted();
    }

    @Test
    public void testResolveSystemProperty_file_yaml() throws Exception {
        this.helper.givenYamlClientConfigFileInWorkDir("foo.yaml", "cluster-yaml-file");
        System.setProperty(SYSPROP_NAME, "foo.yaml");
        ClientConfig config = new YamlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-yaml-file", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_yaml() throws Exception {
        this.helper.givenYamlClientConfigFileOnClasspath("foo.yaml", "cluster-yaml-classpath");
        System.setProperty(SYSPROP_NAME, "classpath:foo.yaml");
        ClientConfig config = new YamlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-yaml-classpath", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentYaml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:idontexist.yaml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("idontexist.yaml");
        new YamlClientConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentYaml_throws() {
        System.setProperty(SYSPROP_NAME, "idontexist.yaml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("idontexist.yaml");
        new YamlClientConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonYaml_throws() throws Exception {
        File file = this.helper.givenYamlClientConfigFileInWorkDir("foo.bar", "irrelevant");
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("suffix");
        this.expectedException.expectMessage("foo.bar");
        new YamlClientConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonYaml_throws() throws Exception {
        this.helper.givenYamlClientConfigFileOnClasspath("foo.bar", "irrelevant");
        System.setProperty(SYSPROP_NAME, "classpath:foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("suffix");
        this.expectedException.expectMessage("foo.bar");
        new YamlClientConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentNonYaml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.bar");
        new YamlClientConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentNonYaml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:idontexist.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("idontexist.bar");
        new YamlClientConfigBuilder().build();
    }

    @Test
    public void testResolveFromWorkDir() throws Exception {
        this.helper.givenYamlClientConfigFileInWorkDir("cluster-yaml-workdir");
        ClientConfig config = new YamlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-yaml-workdir", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveFromClasspath() throws Exception {
        this.helper.givenYamlClientConfigFileOnClasspath("cluster-yaml-classpath");
        ClientConfig config = new YamlClientConfigBuilder().build();
        Assert.assertEquals((Object)"cluster-yaml-classpath", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveDefault() {
        ClientConfig config = new YamlClientConfigBuilder().build();
        Assert.assertEquals((Object)"dev", (Object)config.getGroupConfig().getName());
    }
}

