/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.AbstractClientConfigBuilderTest;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.YamlConfigBuilderTest;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.util.RootCauseMatcher;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class YamlClientConfigBuilderTest
extends AbstractClientConfigBuilderTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void init() throws Exception {
        YamlClientConfigBuilderTest.assumeThatJDK8OrHigher();
        URL schemaResource = YamlConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-full.yaml");
        this.fullClientConfig = new YamlClientConfigBuilder(schemaResource).build();
        URL schemaResourceDefault = YamlConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-default.yaml");
        this.defaultClientConfig = new YamlClientConfigBuilder(schemaResourceDefault).build();
    }

    @After
    @Before
    public void beforeAndAfter() {
        System.clearProperty("hazelcast.client.config");
    }

    @Override
    @Test(expected=InvalidConfigurationException.class)
    public void testInvalidRootElement() {
        String yaml = "hazelcast:\n  group:\n    name: dev\n    password: clusterpass";
        YamlClientConfigBuilderTest.buildConfig(yaml);
    }

    @Override
    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingFile() throws IOException {
        File file = File.createTempFile("foo", ".yaml");
        IOUtil.delete((File)file);
        System.setProperty("hazelcast.client.config", file.getAbsolutePath());
        new YamlClientConfigBuilder();
    }

    @Override
    @Test
    public void loadingThroughSystemProperty_existingFile() throws IOException {
        String yaml = "hazelcast-client:\n  group:\n    name: foobar\n    password: dev-pass";
        File file = File.createTempFile("foo", ".yaml");
        file.deleteOnExit();
        PrintWriter writer = new PrintWriter(file, "UTF-8");
        writer.println(yaml);
        writer.close();
        System.setProperty("hazelcast.client.config", file.getAbsolutePath());
        YamlClientConfigBuilder configBuilder = new YamlClientConfigBuilder();
        ClientConfig config = configBuilder.build();
        Assert.assertEquals((Object)"foobar", (Object)config.getGroupConfig().getName());
    }

    @Override
    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingClasspathResource() throws IOException {
        System.setProperty("hazelcast.client.config", "classpath:idontexist.yaml");
        new YamlClientConfigBuilder();
    }

    @Override
    @Test
    public void loadingThroughSystemProperty_existingClasspathResource() throws IOException {
        System.setProperty("hazelcast.client.config", "classpath:test-hazelcast-client.yaml");
        YamlClientConfigBuilder configBuilder = new YamlClientConfigBuilder();
        ClientConfig config = configBuilder.build();
        Assert.assertEquals((Object)"foobar-yaml", (Object)config.getGroupConfig().getName());
        Assert.assertEquals((Object)"com.hazelcast.nio.ssl.BasicSSLContextFactory", (Object)config.getNetworkConfig().getSSLConfig().getFactoryClassName());
        Assert.assertEquals((long)128L, (long)config.getNetworkConfig().getSocketOptions().getBufferSize());
        Assert.assertFalse((boolean)config.getNetworkConfig().getSocketOptions().isKeepAlive());
        Assert.assertFalse((boolean)config.getNetworkConfig().getSocketOptions().isTcpNoDelay());
        Assert.assertEquals((long)3L, (long)config.getNetworkConfig().getSocketOptions().getLingerSeconds());
    }

    @Override
    @Test
    public void testFlakeIdGeneratorConfig() {
        String yaml = "hazelcast-client:\n  flake-id-generator:\n    gen:\n      prefetch-count: 3\n      prefetch-validity-millis: 10";
        ClientConfig config = YamlClientConfigBuilderTest.buildConfig(yaml);
        ClientFlakeIdGeneratorConfig fConfig = config.findFlakeIdGeneratorConfig("gen");
        Assert.assertEquals((Object)"gen", (Object)fConfig.getName());
        Assert.assertEquals((long)3L, (long)fConfig.getPrefetchCount());
        Assert.assertEquals((long)10L, (long)fConfig.getPrefetchValidityMillis());
    }

    @Override
    @Test
    public void testSecurityConfig_onlyFactory() {
        String yaml = "hazelcast-client:\n  security:\n    credentials-factory:\n      class-name: com.hazelcast.examples.MyCredentialsFactory\n      properties:\n        property: value";
        ClientConfig config = YamlClientConfigBuilderTest.buildConfig(yaml);
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        CredentialsFactoryConfig credentialsFactoryConfig = securityConfig.getCredentialsFactoryConfig();
        Assert.assertEquals((Object)"com.hazelcast.examples.MyCredentialsFactory", (Object)credentialsFactoryConfig.getClassName());
        Properties properties = credentialsFactoryConfig.getProperties();
        Assert.assertEquals((Object)"value", (Object)properties.getProperty("property"));
    }

    @Override
    @Test(expected=InvalidConfigurationException.class)
    public void testHazelcastClientTagAppearsTwice() {
        String yaml = "hazelcast-client: {}\nhazelcast-client: {}";
        YamlClientConfigBuilderTest.buildConfig(yaml);
    }

    @Override
    @Test
    public void testNearCacheInMemoryFormatNative_withKeysByReference() {
        String mapName = "testMapNearCacheInMemoryFormatNative";
        String yaml = "hazelcast-client:\n  near-cache:\n    " + mapName + ":\n      in-memory-format: NATIVE\n      serialize-keys: false";
        ClientConfig clientConfig = YamlClientConfigBuilderTest.buildConfig(yaml);
        NearCacheConfig ncConfig = clientConfig.getNearCacheConfig(mapName);
        Assert.assertEquals((Object)InMemoryFormat.NATIVE, (Object)ncConfig.getInMemoryFormat());
        Assert.assertTrue((boolean)ncConfig.isSerializeKeys());
    }

    @Override
    @Test
    public void testNearCacheEvictionPolicy() {
        String yaml = "hazelcast-client:\n  near-cache:\n    lfu:\n      eviction:\n        eviction-policy: LFU\n    lru:\n      eviction:\n        eviction-policy: LRU\n    none:\n      eviction:\n        eviction-policy: NONE\n    random:\n      eviction:\n        eviction-policy: RANDOM";
        ClientConfig clientConfig = YamlClientConfigBuilderTest.buildConfig(yaml);
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)this.getNearCacheEvictionPolicy("lfu", clientConfig));
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)this.getNearCacheEvictionPolicy("lru", clientConfig));
        Assert.assertEquals((Object)EvictionPolicy.NONE, (Object)this.getNearCacheEvictionPolicy("none", clientConfig));
        Assert.assertEquals((Object)EvictionPolicy.RANDOM, (Object)this.getNearCacheEvictionPolicy("random", clientConfig));
    }

    @Override
    @Test
    public void testClientUserCodeDeploymentConfig() {
        String yaml = "hazelcast-client:\n  user-code-deployment:\n    enabled: true\n    jarPaths:\n      - /User/test/test.jar\n    classNames:\n      - test.testClassName\n      - test.testClassName2";
        ClientConfig clientConfig = YamlClientConfigBuilderTest.buildConfig(yaml);
        ClientUserCodeDeploymentConfig userCodeDeploymentConfig = clientConfig.getUserCodeDeploymentConfig();
        Assert.assertTrue((boolean)userCodeDeploymentConfig.isEnabled());
        List classNames = userCodeDeploymentConfig.getClassNames();
        Assert.assertEquals((long)2L, (long)classNames.size());
        Assert.assertTrue((boolean)classNames.contains("test.testClassName"));
        Assert.assertTrue((boolean)classNames.contains("test.testClassName2"));
        List jarPaths = userCodeDeploymentConfig.getJarPaths();
        Assert.assertEquals((long)1L, (long)jarPaths.size());
        Assert.assertTrue((boolean)jarPaths.contains("/User/test/test.jar"));
    }

    @Override
    @Test
    public void testReliableTopic_defaults() {
        String yaml = "hazelcast-client:\n  reliable-topic:\n    rel-topic: {}";
        ClientConfig config = YamlClientConfigBuilderTest.buildConfig(yaml);
        ClientReliableTopicConfig reliableTopicConfig = config.getReliableTopicConfig("rel-topic");
        Assert.assertEquals((Object)"rel-topic", (Object)reliableTopicConfig.getName());
        Assert.assertEquals((long)10L, (long)reliableTopicConfig.getReadBatchSize());
        Assert.assertEquals((Object)TopicOverloadPolicy.BLOCK, (Object)reliableTopicConfig.getTopicOverloadPolicy());
    }

    @Override
    @Test(expected=InvalidConfigurationException.class)
    public void testQueryCacheBothPredicateDefinedThrows() {
        String yaml = "hazelcast-client:\n  query-caches:\n    query-cache-name:\n      map-name: map-name\n      predicate:\n        class-name: com.hazelcast.example.Predicate\n        sql: \"%age=40\"";
        YamlClientConfigBuilderTest.buildConfig(yaml);
    }

    @Override
    @Test(expected=InvalidConfigurationException.class)
    public void testQueryCacheNoPredicateDefinedThrows() {
        String yaml = "hazelcast-client:\n  query-caches:\n    query-cache-name:\n      predicate: {}";
        YamlClientConfigBuilderTest.buildConfig(yaml);
    }

    @Override
    @Test
    public void testLoadBalancerRandom() {
        String yaml = "hazelcast-client:\n  load-balancer:\n    type: random";
        ClientConfig config = YamlClientConfigBuilderTest.buildConfig(yaml);
        YamlClientConfigBuilderTest.assertInstanceOf(RandomLB.class, (Object)config.getLoadBalancer());
    }

    @Override
    @Test
    public void testLoadBalancerRoundRobin() {
        String yaml = "hazelcast-client:\n  load-balancer:\n    type: round-robin";
        ClientConfig config = YamlClientConfigBuilderTest.buildConfig(yaml);
        YamlClientConfigBuilderTest.assertInstanceOf(RoundRobinLB.class, (Object)config.getLoadBalancer());
    }

    @Test
    public void testNullInMapThrows() {
        String yaml = "hazelcast-client:\n  group:\n  name: instanceName";
        this.expected.expect((Matcher)new RootCauseMatcher(InvalidConfigurationException.class, "hazelcast-client/group"));
        YamlClientConfigBuilderTest.buildConfig(yaml);
    }

    @Test
    public void testNullInSequenceThrows() {
        String yaml = "hazelcast-client:\n  client-labels:\n    - admin\n    -\n";
        this.expected.expect((Matcher)new RootCauseMatcher(InvalidConfigurationException.class, "hazelcast-client/client-labels"));
        YamlClientConfigBuilderTest.buildConfig(yaml);
    }

    @Test
    public void testExplicitNullScalarThrows() {
        String yaml = "hazelcast-client:\n  group:\n   name: !!null";
        this.expected.expect((Matcher)new RootCauseMatcher(InvalidConfigurationException.class, "hazelcast-client/group/name"));
        YamlClientConfigBuilderTest.buildConfig(yaml);
    }

    public static ClientConfig buildConfig(String yaml) {
        ByteArrayInputStream bis = new ByteArrayInputStream(yaml.getBytes());
        YamlClientConfigBuilder configBuilder = new YamlClientConfigBuilder((InputStream)bis);
        return configBuilder.build();
    }

    static ClientConfig buildConfig(String xml, Properties properties) {
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
        YamlClientConfigBuilder configBuilder = new YamlClientConfigBuilder((InputStream)bis);
        configBuilder.setProperties(properties);
        return configBuilder.build();
    }

    static ClientConfig buildConfig(String yaml, String key, String value) {
        Properties properties = new Properties();
        properties.setProperty(key, value);
        return YamlClientConfigBuilderTest.buildConfig(yaml, properties);
    }
}

