/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.YamlClientFailoverConfigBuilder;
import com.hazelcast.config.helpers.DeclarativeConfigFileHelper;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class YamlClientFailoverConfigBuilderConfigResolutionTest {
    private static final String SYSPROP_NAME = "hazelcast.client.failover.config";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private DeclarativeConfigFileHelper helper = new DeclarativeConfigFileHelper();

    @Before
    public void setUp() {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        System.clearProperty(SYSPROP_NAME);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty(SYSPROP_NAME);
        this.helper.ensureTestConfigDeleted();
    }

    @Test
    public void testResolveSystemProperty_file_yaml() throws Exception {
        this.helper.givenYamlClientFailoverConfigFileInWorkDir("foo.yaml", 42);
        System.setProperty(SYSPROP_NAME, "foo.yaml");
        ClientFailoverConfig config = new YamlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_yaml() throws Exception {
        this.helper.givenYamlClientFailoverConfigFileOnClasspath("foo.yaml", 42);
        System.setProperty(SYSPROP_NAME, "classpath:foo.yaml");
        ClientFailoverConfig config = new YamlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentYaml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:idontexist.yaml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("idontexist.yaml");
        new YamlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentYaml_throws() {
        System.setProperty(SYSPROP_NAME, "idontexist.yaml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("idontexist.yaml");
        new YamlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonYaml_throws() throws Exception {
        File file = this.helper.givenYamlClientFailoverConfigFileInWorkDir("foo.bar", 42);
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("suffix");
        this.expectedException.expectMessage("foo.bar");
        new YamlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonYaml_throws() throws Exception {
        this.helper.givenYamlClientFailoverConfigFileOnClasspath("foo.bar", 42);
        System.setProperty(SYSPROP_NAME, "classpath:foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("suffix");
        this.expectedException.expectMessage("foo.bar");
        new YamlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentNonYaml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.bar");
        new YamlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentNonYaml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:idontexist.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("idontexist.bar");
        new YamlClientFailoverConfigBuilder().build();
    }

    @Test
    public void testResolveFromWorkDir() throws Exception {
        this.helper.givenYamlClientFailoverConfigFileInWorkDir(42);
        ClientFailoverConfig config = new YamlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveFromClasspath() throws Exception {
        this.helper.givenYamlClientFailoverConfigFileOnClasspath(42);
        ClientFailoverConfig config = new YamlClientFailoverConfigBuilder().build();
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveDefault() {
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("Failed to load ClientFailoverConfig");
        new YamlClientFailoverConfigBuilder().build();
    }
}

