/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.AbstractClientFailoverConfigBuilderTest;
import com.hazelcast.client.config.ClientFailoverClasspathYamlConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.YamlClientFailoverConfigBuilder;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.RootCauseMatcher;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class YamlClientFailoverConfigBuilderTest
extends AbstractClientFailoverConfigBuilderTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void init() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        URL schemaResource = YamlClientFailoverConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-failover-sample.yaml");
        this.fullClientConfig = new YamlClientFailoverConfigBuilder(schemaResource).build();
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testInvalidRootElement() {
        String yaml = "hazelcast:\n  group:\n    name: dev\n    password: clusterpass";
        YamlClientFailoverConfigBuilderTest.buildConfig(yaml);
    }

    @Test
    public void testExpectsAtLeastOneConfig() {
        String yaml = "hazelcast-client-failover:\n  clients: {}";
        this.expected.expect((Matcher)new RootCauseMatcher(InvalidConfigurationException.class, "hazelcast-client-failover/clients"));
        YamlClientFailoverConfigBuilderTest.buildConfig(yaml);
    }

    @Override
    @Test
    public void testVariableReplacementFromProperties() {
        String yaml = "hazelcast-client-failover:\n  clients:\n    - hazelcast-client-c1.yaml\n    - hazelcast-client-c2.yaml\n  try-count: ${try-count}";
        Properties properties = new Properties();
        properties.setProperty("try-count", "11");
        ClientFailoverConfig config = YamlClientFailoverConfigBuilderTest.buildConfig(yaml, properties);
        Assert.assertEquals((long)11L, (long)config.getTryCount());
    }

    @Override
    @Test
    public void testVariableReplacementFromSystemProperties() {
        String yaml = "hazelcast-client-failover:\n  clients:\n    - hazelcast-client-c1.yaml\n    - hazelcast-client-c2.yaml\n  try-count: ${try-count}";
        System.setProperty("try-count", "11");
        ClientFailoverConfig config = YamlClientFailoverConfigBuilderTest.buildConfig(yaml);
        Assert.assertEquals((long)11L, (long)config.getTryCount());
    }

    @Override
    @Test
    public void testWithClasspathConfig() {
        ClientFailoverClasspathYamlConfig config = new ClientFailoverClasspathYamlConfig("hazelcast-client-failover-sample.yaml");
        this.assertSampleFailoverConfig((ClientFailoverConfig)config);
    }

    @Override
    @Test
    public void testVariableReplacementFromSystemPropertiesWithClasspathConfig() {
        System.setProperty("try-count", "13");
        ClientFailoverClasspathYamlConfig config = new ClientFailoverClasspathYamlConfig("hazelcast-client-failover-sample-with-variable.yaml");
        Assert.assertEquals((long)13L, (long)config.getTryCount());
    }

    @Override
    @Test
    public void loadingThroughSystemProperty_existingClasspathResource() {
        System.setProperty("hazelcast.client.failover.config", "classpath:hazelcast-client-failover-sample.yaml");
        ClientFailoverConfig config = this.buildConfig();
        this.assertSampleFailoverConfig(config);
    }

    @Override
    ClientFailoverConfig buildConfig() {
        return new YamlClientFailoverConfigBuilder().build();
    }

    private static ClientFailoverConfig buildConfig(String yaml) {
        return YamlClientFailoverConfigBuilderTest.buildConfig(yaml, null);
    }

    private static ClientFailoverConfig buildConfig(String yaml, Properties properties) {
        ByteArrayInputStream bis = new ByteArrayInputStream(yaml.getBytes());
        YamlClientFailoverConfigBuilder configBuilder = new YamlClientFailoverConfigBuilder((InputStream)bis);
        if (properties != null) {
            configBuilder.setProperties(properties);
        }
        return configBuilder.build();
    }
}

