/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.networking.nio.AbstractAdvancedNetworkIntegrationTest;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.SlowTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={SlowTest.class})
public class AdvancedNetworkingClientCommunicationIntegrationTest
extends AbstractAdvancedNetworkIntegrationTest {
    @Test
    public void testClientConnectionToEndpoints() {
        Config config = this.createCompleteMultiSocketConfig();
        this.newHazelcastInstance(config);
        HazelcastInstance client = null;
        try {
            client = this.createClient(11001);
            client.getMap("whatever");
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
        this.testClientConnectFailOnPort(11000);
        this.testClientConnectFailOnPort(11002);
        this.testClientConnectFailOnPort(11004);
        this.testClientConnectFailOnPort(11005);
    }

    private HazelcastInstance createClient(int port) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{"127.0.0.1:" + port});
        clientConfig.getNetworkConfig().setConnectionTimeout(3000);
        return HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    private void testClientConnectFailOnPort(int port) {
        try {
            this.createClient(port);
            Assert.fail((String)("Client connect should throw IllegalStateException for port " + port));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

