/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.connection.nio.DefaultClientConnectionStrategy;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.util.ClientStateListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClusterConnectionRetryTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testConnectionExponentialRetryAttempts() throws InterruptedException {
        int retryTimeoutMultiplier = 2;
        int baseRetryTimeoutMillis = 100;
        int capRetryTimeoutMillis = 700;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{"127.0.0.1:5701"});
        clientConfig.setProperty("hazelcast.client.connection.strategy.classname", RecordingStrategy.class.getName());
        ClientConnectionStrategyConfig connectionStrategyConfig = clientConfig.getConnectionStrategyConfig();
        connectionStrategyConfig.setAsyncStart(true);
        ConnectionRetryConfig connectionRetryConfig = connectionStrategyConfig.getConnectionRetryConfig();
        connectionRetryConfig.setJitter(0.0);
        connectionRetryConfig.setFailOnMaxBackoff(true);
        connectionRetryConfig.setMultiplier((double)retryTimeoutMultiplier);
        connectionRetryConfig.setInitialBackoffMillis(baseRetryTimeoutMillis);
        connectionRetryConfig.setMaxBackoffMillis(capRetryTimeoutMillis);
        connectionRetryConfig.setEnabled(true);
        ClientStateListener clientStateListener = new ClientStateListener(clientConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        ClientConnectionManagerImpl connectionManager = (ClientConnectionManagerImpl)clientImpl.getConnectionManager();
        RecordingStrategy connectionStrategy = (RecordingStrategy)connectionManager.getConnectionStrategy();
        clientStateListener.awaitDisconnected();
        LinkedHashSet<Long> attemptTimeStamps = connectionStrategy.getAttemptTimeStamps();
        Iterator iterator = attemptTimeStamps.iterator();
        Long startPoint = (Long)iterator.next();
        Long last = 0L;
        int expectedSleepBetweenAttempts = baseRetryTimeoutMillis;
        while (iterator.hasNext()) {
            Long attemptTimeStamp = (Long)iterator.next();
            long actualSleepBetweenAttempts = attemptTimeStamp - startPoint - last;
            ClusterConnectionRetryTest.assertGreaterOrEquals((String)"sleep between attempts", (long)actualSleepBetweenAttempts, (long)expectedSleepBetweenAttempts);
            expectedSleepBetweenAttempts *= retryTimeoutMultiplier;
            expectedSleepBetweenAttempts = Math.min(capRetryTimeoutMillis, expectedSleepBetweenAttempts);
            last = attemptTimeStamp - startPoint;
        }
    }

    @Test
    public void testConnectionExponentialRetryAttempts_jitterEnabled() throws InterruptedException {
        int retryTimeoutMultiplier = 2;
        int initialBackoffMillis = 100;
        int capRetryTimeoutMillis = 700;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{"127.0.0.1:5701"});
        clientConfig.setProperty("hazelcast.client.connection.strategy.classname", RecordingStrategy.class.getName());
        ClientConnectionStrategyConfig connectionStrategyConfig = clientConfig.getConnectionStrategyConfig();
        connectionStrategyConfig.setAsyncStart(true);
        ConnectionRetryConfig connectionRetryConfig = connectionStrategyConfig.getConnectionRetryConfig();
        double jitter = 0.5;
        connectionRetryConfig.setJitter(jitter);
        connectionRetryConfig.setFailOnMaxBackoff(true);
        connectionRetryConfig.setMultiplier((double)retryTimeoutMultiplier);
        connectionRetryConfig.setInitialBackoffMillis(initialBackoffMillis);
        connectionRetryConfig.setMaxBackoffMillis(capRetryTimeoutMillis);
        connectionRetryConfig.setEnabled(true);
        ClientStateListener clientStateListener = new ClientStateListener(clientConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        ClientConnectionManagerImpl connectionManager = (ClientConnectionManagerImpl)clientImpl.getConnectionManager();
        RecordingStrategy connectionStrategy = (RecordingStrategy)connectionManager.getConnectionStrategy();
        clientStateListener.awaitDisconnected();
        LinkedHashSet<Long> attemptTimeStamps = connectionStrategy.getAttemptTimeStamps();
        Iterator iterator = attemptTimeStamps.iterator();
        Long startPoint = (Long)iterator.next();
        Long last = 0L;
        int currentBackoffMillis = initialBackoffMillis;
        while (iterator.hasNext()) {
            long attemptTimeStamp = (Long)iterator.next();
            long actualSleepBetweenAttempts = attemptTimeStamp - startPoint - last;
            long lowerBound = (long)((double)currentBackoffMillis - (double)currentBackoffMillis * jitter);
            ClusterConnectionRetryTest.assertGreaterOrEquals((String)"sleep between attempts", (long)actualSleepBetweenAttempts, (long)lowerBound);
            currentBackoffMillis *= retryTimeoutMultiplier;
            last = attemptTimeStamp - startPoint;
        }
    }

    @Test
    public void testConnectionDefaultRetryAttempts() throws InterruptedException {
        int connectionAttemptLimit = 3;
        int connectionAttemptPeriod = 100;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{"127.0.0.1:5701"});
        clientConfig.setProperty("hazelcast.client.connection.strategy.classname", RecordingStrategy.class.getName());
        ClientConnectionStrategyConfig connectionStrategyConfig = clientConfig.getConnectionStrategyConfig();
        connectionStrategyConfig.setAsyncStart(true);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(connectionAttemptLimit);
        clientConfig.getNetworkConfig().setConnectionAttemptPeriod(connectionAttemptPeriod);
        ClientStateListener clientStateListener = new ClientStateListener(clientConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        ClientConnectionManagerImpl connectionManager = (ClientConnectionManagerImpl)clientImpl.getConnectionManager();
        RecordingStrategy connectionStrategy = (RecordingStrategy)connectionManager.getConnectionStrategy();
        clientStateListener.awaitDisconnected();
        LinkedHashSet<Long> attemptTimeStamps = connectionStrategy.getAttemptTimeStamps();
        Assert.assertEquals((long)connectionAttemptLimit, (long)attemptTimeStamps.size());
        Iterator iterator = attemptTimeStamps.iterator();
        Long startPoint = (Long)iterator.next();
        Long last = 0L;
        while (iterator.hasNext()) {
            Long attemptTimeStamp = (Long)iterator.next();
            long actualSleepBetweenAttempts = attemptTimeStamp - startPoint - last;
            ClusterConnectionRetryTest.assertGreaterOrEquals((String)"sleep between attempts", (long)actualSleepBetweenAttempts, (long)connectionAttemptPeriod);
            last = attemptTimeStamp - startPoint;
        }
    }

    public static class RecordingStrategy
    extends DefaultClientConnectionStrategy {
        private final LinkedHashSet<Long> attemptTimeStamps = new LinkedHashSet();

        public void beforeConnectToCluster(Address target) {
            this.attemptTimeStamps.add(System.currentTimeMillis());
            super.beforeOpenConnection(target);
        }

        LinkedHashSet<Long> getAttemptTimeStamps() {
            return this.attemptTimeStamps;
        }
    }
}

