/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.nio.ClusterConnectorServiceImpl;
import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.ClientDiscoveryService;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ConnectMemberListOrderTest
extends ClientTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();
    @Parameterized.Parameter
    public String shuffleMemberList;

    @Parameterized.Parameters(name="shuffleMemberList == {0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"false"}, {"true"});
    }

    @After
    public void cleanup() {
        this.factory.shutdownAll();
    }

    @Test
    public void testPossibleMemberAddressesAfterDisconnection() throws Exception {
        HazelcastInstance instance = this.factory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.setProperty(ClientProperty.SHUFFLE_MEMBER_LIST.getName(), this.shuffleMemberList);
        final CountDownLatch connectedBack = new CountDownLatch(2);
        config.addListenerConfig(new ListenerConfig((EventListener)new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED.equals((Object)event.getState())) {
                    connectedBack.countDown();
                }
            }
        }));
        HazelcastInstance client = this.factory.newHazelcastClient(config);
        this.factory.newHazelcastInstance();
        this.factory.newHazelcastInstance();
        this.makeSureConnectedToServers(client, 3);
        Address lastConnectedMemberAddress = new Address((InetSocketAddress)instance.getLocalEndpoint().getSocketAddress());
        instance.shutdown();
        ConnectMemberListOrderTest.assertOpenEventually((CountDownLatch)connectedBack);
        Collection<Address> possibleMemberAddresses = this.getPossibleMemberAddresses(client);
        Assert.assertEquals((long)3L, (long)possibleMemberAddresses.size());
        Assert.assertNotEquals((String)("possibleMemberAddresses : " + possibleMemberAddresses + ", lastConnectedMemberAddress " + lastConnectedMemberAddress), (Object)possibleMemberAddresses.iterator().next(), (Object)lastConnectedMemberAddress);
    }

    private Collection<Address> getPossibleMemberAddresses(HazelcastInstance client) {
        HazelcastClientInstanceImpl instanceImpl = this.getHazelcastClientInstanceImpl(client);
        ClientDiscoveryService clientDiscoveryService = instanceImpl.getClientDiscoveryService();
        clientDiscoveryService.resetSearch();
        CandidateClusterContext clusterContext = clientDiscoveryService.current();
        ClusterConnectorServiceImpl clusterConnectorService = (ClusterConnectorServiceImpl)instanceImpl.getClusterConnectorService();
        return clusterConnectorService.getPossibleMemberAddresses(clusterContext.getAddressProvider());
    }
}

