/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connectionstrategy;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.EventListener;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ConfiguredBehaviourTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=HazelcastClientOfflineException.class)
    public void testAsyncStartTrueNoCluster() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getConnectionStrategyConfig().setAsyncStart(true);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        client.getMap(ConfiguredBehaviourTest.randomMapName());
    }

    @Test(expected=HazelcastClientNotActiveException.class)
    public void testAsyncStartTrueNoCluster_thenShutdown() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getConnectionStrategyConfig().setAsyncStart(true);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        client.shutdown();
        client.getMap(ConfiguredBehaviourTest.randomMapName());
    }

    @Test
    public void testAsyncStartTrue() {
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        ClientConfig clientConfig = new ClientConfig();
        Address memberAddress = this.hazelcastFactory.nextAddress();
        clientConfig.getNetworkConfig().addAddress(new String[]{"8.8.8.8", memberAddress.getHost() + ":" + memberAddress.getPort()});
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState().equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) {
                    connectedLatch.countDown();
                }
            }
        }));
        clientConfig.getConnectionStrategyConfig().setAsyncStart(true);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        Assert.assertTrue((boolean)client.getLifecycleService().isRunning());
        this.hazelcastFactory.newHazelcastInstance(memberAddress, null);
        ConfiguredBehaviourTest.assertOpenEventually((CountDownLatch)connectedLatch);
        client.getMap(ConfiguredBehaviourTest.randomMapName());
    }

    @Test(expected=HazelcastClientNotActiveException.class)
    public void testReconnectModeOFFSingleMember() {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.OFF);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.SHUTDOWN.equals((Object)event.getState())) {
                    disconnectedLatch.countDown();
                }
            }
        });
        IMap map = client.getMap(ConfiguredBehaviourTest.randomMapName());
        map.put((Object)1, (Object)5);
        hazelcastInstance.shutdown();
        ConfiguredBehaviourTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        map.put((Object)1, (Object)5);
    }

    @Test(expected=HazelcastClientNotActiveException.class)
    public void testReconnectModeOFFTwoMembers() {
        this.hazelcastFactory.newInstances(this.getConfig(), 2);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.OFF);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.SHUTDOWN.equals((Object)event.getState())) {
                    disconnectedLatch.countDown();
                }
            }
        });
        IMap map = client.getMap(ConfiguredBehaviourTest.randomMapName());
        map.put((Object)1, (Object)5);
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(client);
        HazelcastInstance ownerServer = this.getOwnerServer(this.hazelcastFactory, clientInstanceImpl);
        ownerServer.shutdown();
        ConfiguredBehaviourTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        map.put((Object)1, (Object)5);
    }

    @Test(expected=HazelcastClientOfflineException.class)
    public void testReconnectModeASYNCSingleMemberInitiallyOffline() {
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED.equals((Object)event.getState())) {
                    disconnectedLatch.countDown();
                }
            }
        });
        hazelcastInstance.shutdown();
        ConfiguredBehaviourTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        client.getMap(ConfiguredBehaviourTest.randomMapName());
    }

    @Test
    public void testReconnectModeASYNCSingleMember() {
        this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState().equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) {
                    connectedLatch.countDown();
                }
            }
        }));
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        Assert.assertTrue((boolean)client.getLifecycleService().isRunning());
        ConfiguredBehaviourTest.assertOpenEventually((CountDownLatch)connectedLatch);
        client.getMap(ConfiguredBehaviourTest.randomMapName());
    }

    @Test
    public void testReconnectModeASYNC_clusterDown_clientGetsOfflineExcption() {
        HazelcastInstance member1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance member2 = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(ConfiguredBehaviourTest.randomMapName());
        member1.shutdown();
        member2.shutdown();
        Assert.assertTrue((boolean)client.getLifecycleService().isRunning());
        for (int i = 0; i < 100; ++i) {
            try {
                map.get((Object)ConfiguredBehaviourTest.randomString());
                Assert.assertTrue((String)"map.get should throw HazelcastClientOfflineException", (boolean)false);
                continue;
            }
            catch (HazelcastClientOfflineException hazelcastClientOfflineException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReconnectModeASYNCSingleMemberStartLate() {
        final CountDownLatch initialConnectionLatch = new CountDownLatch(1);
        final CountDownLatch reconnectedLatch = new CountDownLatch(1);
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState().equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) {
                    initialConnectionLatch.countDown();
                }
            }
        }));
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        ConfiguredBehaviourTest.assertOpenEventually((CountDownLatch)initialConnectionLatch);
        hazelcastInstance.shutdown();
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState().equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) {
                    reconnectedLatch.countDown();
                }
            }
        });
        this.hazelcastFactory.newHazelcastInstance();
        Assert.assertTrue((boolean)client.getLifecycleService().isRunning());
        ConfiguredBehaviourTest.assertOpenEventually((CountDownLatch)reconnectedLatch);
        client.getMap(ConfiguredBehaviourTest.randomMapName());
    }

    @Test
    public void testReconnectModeASYNCTwoMembers() {
        this.hazelcastFactory.newInstances(this.getConfig(), 2);
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        final CountDownLatch reconnectedLatch = new CountDownLatch(1);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState().equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) {
                    connectedLatch.countDown();
                }
            }
        }));
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        Assert.assertTrue((boolean)client.getLifecycleService().isRunning());
        ConfiguredBehaviourTest.assertOpenEventually((CountDownLatch)connectedLatch);
        IMap map = client.getMap(ConfiguredBehaviourTest.randomMapName());
        map.put((Object)1, (Object)5);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED.equals((Object)event.getState())) {
                    disconnectedLatch.countDown();
                }
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED.equals((Object)event.getState())) {
                    reconnectedLatch.countDown();
                }
            }
        });
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(client);
        HazelcastInstance ownerServer = this.getOwnerServer(this.hazelcastFactory, clientInstanceImpl);
        ownerServer.shutdown();
        ConfiguredBehaviourTest.assertOpenEventually((CountDownLatch)reconnectedLatch);
        map.get((Object)1);
    }
}

