/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class CPSubsystemImplTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void init() {
        this.factory = new TestHazelcastFactory();
    }

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test
    public void test_atomicLong_whenCPSubsystemNotConfigured() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.thrown.expect(HazelcastException.class);
        client.getCPSubsystem().getAtomicLong("long");
    }

    @Test
    public void test_atomicReference_whenCPSubsystemNotConfigured() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.thrown.expect(HazelcastException.class);
        client.getCPSubsystem().getAtomicReference("ref");
    }

    @Test
    public void test_lock_whenCPSubsystemNotConfigured() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.thrown.expect(HazelcastException.class);
        client.getCPSubsystem().getLock("lock");
    }

    @Test
    public void test_semaphore_whenCPSubsystemNotConfigured() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.thrown.expect(HazelcastException.class);
        client.getCPSubsystem().getSemaphore("semaphore");
    }

    @Test
    public void test_countDownLatch_whenCPSubsystemNotConfigured() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.thrown.expect(HazelcastException.class);
        client.getCPSubsystem().getAtomicLong("latch");
    }

    @Test
    public void test_cpSubsystemManagementService_whenCPSubsystemNotConfigured() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.thrown.expect(UnsupportedOperationException.class);
        client.getCPSubsystem().getCPSubsystemManagementService();
    }

    @Test
    public void test_cpSessionManagementService_whenCPSubsystemNotConfigured() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.thrown.expect(UnsupportedOperationException.class);
        client.getCPSubsystem().getCPSessionManagementService();
    }

    @Test
    public void test_atomicLong_whenCPSubsystemConfigured() {
        Config config = new Config();
        config.getCPSubsystemConfig().setCPMemberCount(3);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        Assert.assertNotNull((Object)client.getCPSubsystem().getAtomicLong("long"));
    }

    @Test
    public void test_atomicReference_whenCPSubsystemConfigured() {
        Config config = new Config();
        config.getCPSubsystemConfig().setCPMemberCount(3);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        Assert.assertNotNull((Object)client.getCPSubsystem().getAtomicReference("ref"));
    }

    @Test
    public void test_lock_whenCPSubsystemConfigured() {
        Config config = new Config();
        config.getCPSubsystemConfig().setCPMemberCount(3);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        Assert.assertNotNull((Object)client.getCPSubsystem().getLock("lock"));
    }

    @Test
    public void test_semaphore_whenCPSubsystemConfigured() {
        Config config = new Config();
        config.getCPSubsystemConfig().setCPMemberCount(3);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        Assert.assertNotNull((Object)client.getCPSubsystem().getSemaphore("semaphore"));
    }

    @Test
    public void test_countDownLatch_whenCPSubsystemConfigured() {
        Config config = new Config();
        config.getCPSubsystemConfig().setCPMemberCount(3);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        Assert.assertNotNull((Object)client.getCPSubsystem().getCountDownLatch("latch"));
    }

    @Test
    public void test_cpSubsystemManagementService_whenCPSubsystemConfigured() {
        Config config = new Config();
        config.getCPSubsystemConfig().setCPMemberCount(3);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.thrown.expect(UnsupportedOperationException.class);
        client.getCPSubsystem().getCPSubsystemManagementService();
    }

    @Test
    public void test_cpSessionManagementService_whenCPSubsystemConfigured() {
        Config config = new Config();
        config.getCPSubsystemConfig().setCPMemberCount(3);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.thrown.expect(UnsupportedOperationException.class);
        client.getCPSubsystem().getCPSessionManagementService();
    }
}

