/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.internal.HazelcastRaftTestSupport;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.OverridePropertyRule;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCPSubsystemRollingUpgrade_3_11_Test
extends HazelcastRaftTestSupport {
    @Rule
    public final OverridePropertyRule version_3_11_rule = OverridePropertyRule.set((String)"hazelcast.internal.override.version", (String)Versions.V3_11.toString());
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected TestHazelcastInstanceFactory createTestFactory() {
        return new TestHazelcastFactory();
    }

    @Test
    public void whenCPDataStructureCreated_thenFailsWithUnsupportedOperationException() {
        int clusterSize = 3;
        for (int i = 0; i < clusterSize; ++i) {
            this.factory.newHazelcastInstance(this.createConfig(clusterSize, clusterSize));
        }
        HazelcastInstance client = ((TestHazelcastFactory)this.factory).newHazelcastClient();
        CPSubsystem cpSubsystem = client.getCPSubsystem();
        this.expectedException.expect(UnsupportedOperationException.class);
        cpSubsystem.getAtomicLong("atomic");
    }
}

