/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.countdownlatch;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.cp.internal.datastructures.countdownlatch.RaftCountDownLatchProxy;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.HazelcastRaftTestSupport;
import com.hazelcast.cp.internal.datastructures.countdownlatch.RaftCountDownLatchService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class RaftCountDownLatchLongAwaitClientTest
extends HazelcastRaftTestSupport {
    private HazelcastInstance[] instances;
    private String objectName = "latch";
    private String proxyName = this.objectName + "@group1";
    private int groupSize = 3;
    private CPGroupId groupId;
    private final long callTimeoutSeconds = 15L;
    private HazelcastInstance client;

    protected TestHazelcastInstanceFactory createTestFactory() {
        return new TestHazelcastFactory();
    }

    @Before
    public void setup() {
        this.instances = this.newInstances(this.groupSize);
        TestHazelcastFactory f = (TestHazelcastFactory)this.factory;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), String.valueOf(15L));
        this.client = f.newHazelcastClient(clientConfig);
        this.groupId = ((RaftCountDownLatchProxy)this.client.getCPSubsystem().getCountDownLatch(this.proxyName)).getGroupId();
    }

    @Test
    public void when_awaitDurationIsLongerThanOperationTimeout_then_invocationFromClientWaits() throws ExecutionException, InterruptedException {
        final ICountDownLatch latch = this.client.getCPSubsystem().getCountDownLatch(this.proxyName);
        final HazelcastInstance instance = this.getLeaderInstance(this.instances, this.groupId);
        latch.trySetCount(1);
        Future f = RaftCountDownLatchLongAwaitClientTest.spawn((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return latch.await(5L, TimeUnit.MINUTES);
            }
        });
        RaftCountDownLatchLongAwaitClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                RaftCountDownLatchService service = (RaftCountDownLatchService)HazelcastTestSupport.getNodeEngineImpl((HazelcastInstance)instance).getService("hz:raft:countDownLatchService");
                Assert.assertFalse((boolean)service.getLiveOperations(RaftCountDownLatchLongAwaitClientTest.this.groupId).isEmpty());
            }
        });
        RaftCountDownLatchLongAwaitClientTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() {
                RaftCountDownLatchService service = (RaftCountDownLatchService)HazelcastTestSupport.getNodeEngineImpl((HazelcastInstance)instance).getService("hz:raft:countDownLatchService");
                Assert.assertFalse((boolean)service.getLiveOperations(RaftCountDownLatchLongAwaitClientTest.this.groupId).isEmpty());
            }
        }, (long)20L);
        latch.countDown();
        RaftCountDownLatchLongAwaitClientTest.assertCompletesEventually((Future)f);
        Assert.assertTrue((boolean)((Boolean)f.get()));
    }

    protected Config createConfig(int cpNodeCount, int groupSize) {
        String callTimeoutStr = String.valueOf(TimeUnit.SECONDS.toMillis(15L));
        return super.createConfig(cpNodeCount, groupSize).setProperty(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS.getName(), callTimeoutStr);
    }
}

