/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.lock;

import com.hazelcast.client.cp.internal.session.ClientProxySessionManager;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.lock.FencedLockBasicTest;
import com.hazelcast.cp.internal.session.AbstractProxySessionManager;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class FencedLockClientBasicTest
extends FencedLockBasicTest {
    protected TestHazelcastInstanceFactory createTestFactory() {
        return new TestHazelcastFactory();
    }

    protected HazelcastInstance[] createInstances() {
        HazelcastInstance[] instances = super.createInstances();
        TestHazelcastFactory f = (TestHazelcastFactory)this.factory;
        this.lockInstance = f.newHazelcastClient();
        return instances;
    }

    @Test
    public void test_lockAutoRelease_onClientShutdown() {
        String proxyName = this.lock.getName();
        this.lock.lock();
        this.lockInstance.shutdown();
        Assert.assertFalse((boolean)this.instances[0].getCPSubsystem().getLock(proxyName).isLocked());
    }

    @Test
    public void test_sessionIsClosedOnCPSubsystemReset() throws Exception {
        this.lock.lock();
        this.instances[0].getCPSubsystem().getCPSubsystemManagementService().restart().get();
        FencedLockClientBasicTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                HazelcastClientProxy clientProxy = (HazelcastClientProxy)FencedLockClientBasicTest.this.lockInstance;
                ClientProxySessionManager proxySessionManager = clientProxy.client.getProxySessionManager();
                Assert.assertEquals((long)-1L, (long)proxySessionManager.getSession((RaftGroupId)FencedLockClientBasicTest.this.lock.getGroupId()));
            }
        });
    }

    protected AbstractProxySessionManager getSessionManager(HazelcastInstance instance) {
        return ((HazelcastClientProxy)this.lockInstance).client.getProxySessionManager();
    }
}

