/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.session;

import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.session.AbstractProxySessionManager;
import com.hazelcast.cp.internal.session.AbstractProxySessionManagerTest;
import com.hazelcast.cp.internal.session.SessionAwareProxy;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientSessionManagerTest
extends AbstractProxySessionManagerTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private HazelcastInstance client;

    protected TestHazelcastInstanceFactory createTestFactory() {
        return new TestHazelcastFactory();
    }

    @Before
    public void setupClient() {
        TestHazelcastFactory f = (TestHazelcastFactory)this.factory;
        this.client = f.newHazelcastClient();
    }

    @Test
    public void testClientSessionManagerShutdown() throws ExecutionException, InterruptedException {
        AbstractProxySessionManager sessionManager = this.getSessionManager();
        SessionProxyImpl proxy = new SessionProxyImpl(sessionManager, this.groupId);
        proxy.createSession();
        Map futures = sessionManager.shutdown();
        Assert.assertEquals((long)1L, (long)futures.size());
        Map.Entry e = futures.entrySet().iterator().next();
        Assert.assertEquals((Object)this.groupId, e.getKey());
        ((ICompletableFuture)e.getValue()).get();
        this.exception.expect(IllegalStateException.class);
        proxy.createSession();
    }

    @After
    public void shutdown() {
        this.factory.terminateAll();
    }

    protected AbstractProxySessionManager getSessionManager() {
        return (AbstractProxySessionManager)Mockito.spy((Object)((HazelcastClientProxy)this.client).client.getProxySessionManager());
    }

    private static class SessionProxyImpl
    extends SessionAwareProxy {
        SessionProxyImpl(AbstractProxySessionManager sessionManager, RaftGroupId groupId) {
            super(sessionManager, groupId);
        }

        long createSession() {
            return super.acquireSession();
        }
    }
}

