/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.executor.tasks.MapPutRunnable;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.test.executor.tasks.CancellationAwareTask;
import com.hazelcast.client.test.executor.tasks.FailingCallable;
import com.hazelcast.client.test.executor.tasks.SelectNoMembers;
import com.hazelcast.client.test.executor.tasks.SerializedCounterCallable;
import com.hazelcast.client.test.executor.tasks.TaskWithUnserializableResponse;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientExecutorServiceTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private HazelcastInstance instance;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() throws IOException {
        Config config = new XmlConfigBuilder(this.getClass().getClassLoader().getResourceAsStream("hazelcast-test-executor.xml")).build();
        ClientConfig clientConfig = new XmlClientConfigBuilder("classpath:hazelcast-client-test-executor.xml").build();
        this.instance = this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetLocalExecutorStats() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        service.getLocalExecutorStats();
    }

    @Test
    public void testIsTerminated() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        Assert.assertFalse((boolean)service.isTerminated());
    }

    @Test
    public void testIsShutdown() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        Assert.assertFalse((boolean)service.isShutdown());
    }

    @Test
    public void testShutdownNow() {
        final IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        service.shutdownNow();
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((boolean)service.isShutdown());
            }
        });
    }

    @Test
    public void testShutdownMultipleTimes() {
        final IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        service.shutdownNow();
        service.shutdown();
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((boolean)service.isShutdown());
            }
        });
    }

    @Test(expected=TimeoutException.class)
    public void testCancellationAwareTask_whenTimeOut() throws InterruptedException, ExecutionException, TimeoutException {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        CancellationAwareTask task = new CancellationAwareTask(Long.MAX_VALUE);
        Future future = service.submit((Callable)task);
        future.get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void testFutureAfterCancellationAwareTaskTimeOut() throws InterruptedException, ExecutionException {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        CancellationAwareTask task = new CancellationAwareTask(Long.MAX_VALUE);
        Future future = service.submit((Callable)task);
        try {
            future.get(1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
    }

    @Test
    @Ignore(value="https://github.com/hazelcast/hazelcast/issues/4677")
    public void testCancelFutureAfterCancellationAwareTaskTimeOut() throws InterruptedException, ExecutionException {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        CancellationAwareTask task = new CancellationAwareTask(Long.MAX_VALUE);
        Future future = service.submit((Callable)task);
        try {
            future.get(1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)future.cancel(true));
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test(expected=CancellationException.class)
    public void testGetFutureAfterCancel() throws InterruptedException, ExecutionException {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        CancellationAwareTask task = new CancellationAwareTask(Long.MAX_VALUE);
        Future future = service.submit((Callable)task);
        try {
            future.get(1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        future.cancel(true);
        future.get();
    }

    @Test(expected=ExecutionException.class)
    public void testSubmitFailingCallableException() throws ExecutionException, InterruptedException {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        Future failingFuture = service.submit((Callable)new FailingCallable());
        failingFuture.get();
    }

    @Test
    public void testSubmitFailingCallableException_withExecutionCallback() throws InterruptedException {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch latch = new CountDownLatch(1);
        service.submit((Callable)new FailingCallable(), (ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
            }

            public void onFailure(Throwable t) {
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test(expected=IllegalStateException.class)
    public void testSubmitFailingCallableReasonExceptionCause() throws Throwable {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        Future failingFuture = service.submit((Callable)new FailingCallable());
        try {
            failingFuture.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test(expected=RejectedExecutionException.class)
    public void testExecute_withNoMemberSelected() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        SelectNoMembers selector = new SelectNoMembers();
        service.execute((Runnable)new MapPutRunnable(mapName), (MemberSelector)selector);
    }

    @Test
    public void testCallableSerializedOnce() throws ExecutionException, InterruptedException {
        String name = HazelcastTestSupport.randomString();
        IExecutorService service = this.client.getExecutorService(name);
        SerializedCounterCallable counterCallable = new SerializedCounterCallable();
        Future future = service.submitToKeyOwner((Callable)counterCallable, (Object)name);
        Assert.assertEquals((Object)2, future.get());
    }

    @Test
    public void testCallableSerializedOnce_submitToAddress() throws ExecutionException, InterruptedException {
        String name = HazelcastTestSupport.randomString();
        IExecutorService service = this.client.getExecutorService(name);
        SerializedCounterCallable counterCallable = new SerializedCounterCallable();
        Future future = service.submitToMember((Callable)counterCallable, this.instance.getCluster().getLocalMember());
        Assert.assertEquals((Object)2, future.get());
    }

    @Test(expected=HazelcastSerializationException.class)
    public void testUnserializableResponse_exceptionPropagatesToClient() throws Throwable {
        IExecutorService service = this.client.getExecutorService("executor");
        TaskWithUnserializableResponse counterCallable = new TaskWithUnserializableResponse();
        Future future = service.submit((Callable)counterCallable);
        try {
            future.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test(expected=HazelcastSerializationException.class)
    public void testUnserializableResponse_exceptionPropagatesToClientCallback() throws Throwable {
        IExecutorService service = this.client.getExecutorService("executor");
        TaskWithUnserializableResponse counterCallable = new TaskWithUnserializableResponse();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference throwable = new AtomicReference();
        service.submit((Callable)counterCallable, new ExecutionCallback(){

            public void onResponse(Object response) {
            }

            public void onFailure(Throwable t) {
                throwable.set(t.getCause());
                countDownLatch.countDown();
            }
        });
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)countDownLatch);
        throw (Throwable)throwable.get();
    }
}

