/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.executor.ExecutorServiceTestSupport;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ExecutorServiceLiteMemberTest {
    private TestHazelcastFactory factory;
    private final String defaultMemberConfigXml = "hazelcast-test-executor.xml";
    private Config liteConfig = new XmlConfigBuilder(this.getClass().getClassLoader().getResourceAsStream("hazelcast-test-executor.xml")).build().setLiteMember(true);
    private Config config = new XmlConfigBuilder(this.getClass().getClassLoader().getResourceAsStream("hazelcast-test-executor.xml")).build();
    private ClientConfig clientConfig = new XmlClientConfigBuilder("classpath:hazelcast-client-test-executor.xml").build();

    private HazelcastInstance newHazelcastInstance() {
        return this.factory.newHazelcastInstance(this.config);
    }

    private HazelcastInstance newHazelcastLiteMember() {
        return this.factory.newHazelcastInstance(this.liteConfig);
    }

    private HazelcastInstance newHazelcastClient() {
        return this.factory.newHazelcastClient(this.clientConfig);
    }

    @Before
    public void before() {
        this.factory = new TestHazelcastFactory();
    }

    @After
    public void after() {
        this.factory.terminateAll();
    }

    @Test(expected=RejectedExecutionException.class)
    public void test_executeRunnable_failsWhenNoLiteMemberExists() {
        this.newHazelcastInstance();
        HazelcastInstance client = this.newHazelcastClient();
        String name = ExecutorServiceTestSupport.randomString();
        IExecutorService executor = client.getExecutorService(name);
        executor.execute((Runnable)new ExecutorServiceTestSupport.ResultSettingRunnable(name), MemberSelectors.LITE_MEMBER_SELECTOR);
    }

    @Test
    public void test_executeRunnable_onLiteMember() {
        final HazelcastInstance lite1 = this.newHazelcastLiteMember();
        final HazelcastInstance lite2 = this.newHazelcastLiteMember();
        this.newHazelcastInstance();
        HazelcastInstance client = this.newHazelcastClient();
        final String name = ExecutorServiceTestSupport.randomString();
        IExecutorService executor = client.getExecutorService(name);
        executor.execute((Runnable)new ExecutorServiceTestSupport.ResultSettingRunnable(name), MemberSelectors.LITE_MEMBER_SELECTOR);
        ExecutorServiceTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                IMap results = lite1.getMap(name);
                Assert.assertEquals((long)1L, (long)results.size());
                boolean executedOnLite1 = results.containsKey((Object)lite1.getCluster().getLocalMember());
                boolean executedOnLite2 = results.containsKey((Object)lite2.getCluster().getLocalMember());
                Assert.assertTrue((executedOnLite1 || executedOnLite2 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void test_executeRunnable_onAllLiteMembers() {
        final HazelcastInstance lite1 = this.newHazelcastLiteMember();
        final HazelcastInstance lite2 = this.newHazelcastLiteMember();
        this.newHazelcastInstance();
        HazelcastInstance client = this.newHazelcastClient();
        final String name = ExecutorServiceTestSupport.randomString();
        IExecutorService executor = client.getExecutorService(name);
        executor.executeOnMembers((Runnable)new ExecutorServiceTestSupport.ResultSettingRunnable(name), MemberSelectors.LITE_MEMBER_SELECTOR);
        ExecutorServiceTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                IMap results = lite1.getMap(name);
                Assert.assertEquals((long)2L, (long)results.size());
                Assert.assertTrue((boolean)results.containsKey((Object)lite1.getCluster().getLocalMember()));
                Assert.assertTrue((boolean)results.containsKey((Object)lite2.getCluster().getLocalMember()));
            }
        });
    }

    @Test(expected=RejectedExecutionException.class)
    public void test_submitCallable_failsWhenNoLiteMemberExists() {
        this.newHazelcastInstance();
        HazelcastInstance client = this.newHazelcastClient();
        IExecutorService executor = client.getExecutorService(ExecutorServiceTestSupport.randomString());
        executor.submit((Callable)new ExecutorServiceTestSupport.LocalMemberReturningCallable(), MemberSelectors.LITE_MEMBER_SELECTOR);
    }

    @Test
    public void test_submitCallable_onLiteMember() throws ExecutionException, InterruptedException {
        HazelcastInstance lite1 = this.newHazelcastLiteMember();
        HazelcastInstance lite2 = this.newHazelcastLiteMember();
        this.newHazelcastInstance();
        HazelcastInstance client = this.newHazelcastClient();
        IExecutorService executor = client.getExecutorService(ExecutorServiceTestSupport.randomString());
        Future future = executor.submit((Callable)new ExecutorServiceTestSupport.LocalMemberReturningCallable(), MemberSelectors.LITE_MEMBER_SELECTOR);
        Member executedMember = (Member)future.get();
        boolean executedOnLite1 = lite1.getCluster().getLocalMember().equals(executedMember);
        boolean executedOnLite2 = lite2.getCluster().getLocalMember().equals(executedMember);
        Assert.assertTrue((executedOnLite1 || executedOnLite2 ? 1 : 0) != 0);
    }

    @Test
    public void test_submitCallable_onLiteMembers() throws ExecutionException, InterruptedException {
        HazelcastInstance lite1 = this.newHazelcastLiteMember();
        HazelcastInstance lite2 = this.newHazelcastLiteMember();
        this.newHazelcastInstance();
        HazelcastInstance client = this.newHazelcastClient();
        IExecutorService executor = client.getExecutorService(ExecutorServiceTestSupport.randomString());
        Map results = executor.submitToMembers((Callable)new ExecutorServiceTestSupport.LocalMemberReturningCallable(), MemberSelectors.LITE_MEMBER_SELECTOR);
        Assert.assertEquals((long)2L, (long)results.size());
        Member liteMember1 = lite1.getCluster().getLocalMember();
        Member liteMember2 = lite2.getCluster().getLocalMember();
        Assert.assertEquals((Object)liteMember1, ((Future)results.get(liteMember1)).get());
        Assert.assertEquals((Object)liteMember2, ((Future)results.get(liteMember2)).get());
    }

    @Test
    public void test_submitCallableWithCallback_toLiteMember() {
        HazelcastInstance lite1 = this.newHazelcastLiteMember();
        HazelcastInstance lite2 = this.newHazelcastLiteMember();
        this.newHazelcastInstance();
        HazelcastInstance client = this.newHazelcastClient();
        ExecutorServiceTestSupport.CountingDownExecutionCallback callback = new ExecutorServiceTestSupport.CountingDownExecutionCallback(1);
        IExecutorService executor = client.getExecutorService(ExecutorServiceTestSupport.randomString());
        executor.submit((Callable)new ExecutorServiceTestSupport.LocalMemberReturningCallable(), MemberSelectors.LITE_MEMBER_SELECTOR, (ExecutionCallback)callback);
        ExecutorServiceTestSupport.assertOpenEventually((CountDownLatch)callback.getLatch());
        Object result = callback.getResult();
        boolean executedOnLite1 = lite1.getCluster().getLocalMember().equals(result);
        boolean executedOnLite2 = lite2.getCluster().getLocalMember().equals(result);
        Assert.assertTrue((executedOnLite1 || executedOnLite2 ? 1 : 0) != 0);
    }

    @Test
    public void test_submitCallableWithCallback_toLiteMembers() {
        final HazelcastInstance lite1 = this.newHazelcastLiteMember();
        final HazelcastInstance lite2 = this.newHazelcastLiteMember();
        this.newHazelcastInstance();
        HazelcastInstance client = this.newHazelcastClient();
        final ExecutorServiceTestSupport.ResultHoldingMultiExecutionCallback callback = new ExecutorServiceTestSupport.ResultHoldingMultiExecutionCallback();
        IExecutorService executor = client.getExecutorService(ExecutorServiceTestSupport.randomString());
        executor.submitToMembers((Callable)new ExecutorServiceTestSupport.LocalMemberReturningCallable(), MemberSelectors.LITE_MEMBER_SELECTOR, (MultiExecutionCallback)callback);
        ExecutorServiceTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Map results = callback.getResults();
                Assert.assertNotNull((Object)results);
                Member liteMember1 = lite1.getCluster().getLocalMember();
                Member liteMember2 = lite2.getCluster().getLocalMember();
                Assert.assertEquals((Object)liteMember1, results.get(liteMember1));
                Assert.assertEquals((Object)liteMember2, results.get(liteMember2));
            }
        });
    }
}

