/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor.durable;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.executor.tasks.MapPutPartitionAwareRunnable;
import com.hazelcast.client.executor.tasks.MapPutRunnable;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.test.executor.tasks.AppendCallable;
import com.hazelcast.client.test.executor.tasks.MapPutPartitionAwareCallable;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.durableexecutor.DurableExecutorServiceFuture;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientDurableExecutorServiceSubmitTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server;
    private HazelcastInstance client;

    @Before
    public void setup() throws IOException {
        Config config = new XmlConfigBuilder(this.getClass().getClassLoader().getResourceAsStream("hazelcast-test-executor.xml")).build();
        ClientConfig clientConfig = new XmlClientConfigBuilder("classpath:hazelcast-client-test-executor.xml").build();
        this.hazelcastFactory.newHazelcastInstance(config);
        this.server = this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=NullPointerException.class)
    public void testSubmitCallableNullTask() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        Callable callable = null;
        service.submit(callable);
    }

    @Test
    public void submitRunnable() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        service.submit((Runnable)runnable);
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertSizeEventually((int)1, (Map)map);
    }

    @Test
    public void testSubmitRunnable_WithResult() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        String givenResult = "givenResult";
        DurableExecutorServiceFuture future = service.submit((Runnable)new MapPutRunnable(mapName), (Object)givenResult);
        Object result = future.get();
        IMap map = this.client.getMap(mapName);
        Assert.assertEquals((Object)givenResult, result);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testSubmitCallable() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        DurableExecutorServiceFuture result = service.submit((Callable)callable);
        Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
    }

    @Test
    public void testSubmitRunnable_withExecutionCallback() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submit((Runnable)runnable).andThen(new ExecutionCallback(){

            public void onResponse(Object response) {
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testSubmitCallable_withExecutionCallback() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        final AtomicReference result = new AtomicReference();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submit((Callable)callable).andThen((ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
                result.set(response);
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
    }

    @Test
    public void submitCallableToKeyOwner() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        DurableExecutorServiceFuture result = service.submitToKeyOwner((Callable)callable, (Object)"key");
        Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
    }

    @Test
    public void submitRunnableToKeyOwner() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submitToKeyOwner((Runnable)runnable, (Object)"key").andThen(new ExecutionCallback(){

            public void onResponse(Object response) {
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void submitCallableToKeyOwner_withExecutionCallback() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        final CountDownLatch responseLatch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        service.submitToKeyOwner((Callable)callable, (Object)"key").andThen((ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
                result.set(response);
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
    }

    @Test
    public void submitRunnablePartitionAware() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        final Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareRunnable<String> runnable = new MapPutPartitionAwareRunnable<String>(mapName, key);
        service.submit(runnable);
        final IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
            }
        });
    }

    @Test
    public void submitRunnablePartitionAware_withResult() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String expectedResult = "result";
        String mapName = HazelcastTestSupport.randomString();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        final Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareRunnable<String> runnable = new MapPutPartitionAwareRunnable<String>(mapName, key);
        DurableExecutorServiceFuture result = service.submit(runnable, (Object)expectedResult);
        final IMap map = this.client.getMap(mapName);
        Assert.assertEquals((Object)expectedResult, result.get());
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
            }
        });
    }

    @Test
    public void submitRunnablePartitionAware_withExecutionCallback() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareRunnable<String> runnable = new MapPutPartitionAwareRunnable<String>(mapName, key);
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submit(runnable).andThen(new ExecutionCallback(){

            public void onResponse(Object response) {
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
    }

    @Test
    public void submitCallablePartitionAware() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareCallable callable = new MapPutPartitionAwareCallable(mapName, (Object)key);
        DurableExecutorServiceFuture result = service.submit((Callable)callable);
        Assert.assertEquals((Object)member.getUuid(), result.get());
        Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
    }

    @Test
    public void submitCallablePartitionAware_WithExecutionCallback() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareCallable runnable = new MapPutPartitionAwareCallable(mapName, (Object)key);
        final AtomicReference result = new AtomicReference();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submit((Callable)runnable).andThen((ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
                result.set(response);
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((Object)member.getUuid(), result.get());
        Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
    }
}

