/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor.durable;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.test.executor.tasks.FailingCallable;
import com.hazelcast.config.Config;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.durableexecutor.DurableExecutorServiceFuture;
import com.hazelcast.executor.ExecutorServiceTestSupport;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.RootCauseMatcher;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientDurableExecutorServiceTest {
    private static final String SINGLE_TASK = "singleTask";
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private HazelcastInstance client;

    @Before
    public void setup() throws IOException {
        Config config = new XmlConfigBuilder(this.getClass().getClassLoader().getResourceAsStream("hazelcast-test-executor.xml")).build();
        ClientConfig clientConfig = new XmlClientConfigBuilder("classpath:hazelcast-client-test-executor.xml").build();
        DurableExecutorConfig durableExecutorConfig = config.getDurableExecutorConfig("singleTask*");
        durableExecutorConfig.setCapacity(1);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testInvokeAll() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        List callables = Collections.emptyList();
        this.expectedException.expect(UnsupportedOperationException.class);
        service.invokeAll(callables);
    }

    @Test
    public void testInvokeAll_WithTimeout() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        List callables = Collections.emptyList();
        this.expectedException.expect(UnsupportedOperationException.class);
        service.invokeAll(callables, 1L, TimeUnit.SECONDS);
    }

    @Test
    public void testInvokeAny() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        List callables = Collections.emptyList();
        this.expectedException.expect(UnsupportedOperationException.class);
        service.invokeAny(callables);
    }

    @Test
    public void testInvokeAny_WithTimeout() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        List callables = Collections.emptyList();
        this.expectedException.expect(UnsupportedOperationException.class);
        service.invokeAny(callables, 1L, TimeUnit.SECONDS);
    }

    @Test
    public void testAwaitTermination() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        Assert.assertFalse((boolean)service.awaitTermination(1L, TimeUnit.SECONDS));
    }

    @Test
    public void test_whenRingBufferIsFull_thenThrowRejectedExecutionException() throws Exception {
        String key = HazelcastTestSupport.randomString();
        DurableExecutorService service = this.client.getDurableExecutorService(SINGLE_TASK + HazelcastTestSupport.randomString());
        service.submitToKeyOwner((Callable)new ExecutorServiceTestSupport.SleepingTask(100L), (Object)key);
        DurableExecutorServiceFuture future = service.submitToKeyOwner((Callable)new ExecutorServiceTestSupport.BasicTestCallable(), (Object)key);
        this.expectedException.expect((Matcher)new RootCauseMatcher(RejectedExecutionException.class));
        future.get();
    }

    @Test
    public void test_whenRingBufferIsFull_thenClientDurableExecutorServiceCompletedFutureIsReturned() throws Exception {
        final AtomicBoolean onResponse = new AtomicBoolean();
        final CountDownLatch onFailureLatch = new CountDownLatch(1);
        String key = HazelcastTestSupport.randomString();
        DurableExecutorService service = this.client.getDurableExecutorService(SINGLE_TASK + HazelcastTestSupport.randomString());
        service.submitToKeyOwner((Callable)new ExecutorServiceTestSupport.SleepingTask(100L), (Object)key);
        DurableExecutorServiceFuture future = service.submitToKeyOwner((Callable)new ExecutorServiceTestSupport.BasicTestCallable(), (Object)key);
        future.andThen((ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
                onResponse.set(true);
            }

            public void onFailure(Throwable t) {
                onFailureLatch.countDown();
            }
        });
        try {
            future.get(1L, TimeUnit.HOURS);
            Assert.fail((String)"We expected that future.get() throws an ExecutionException!");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            future.getTaskId();
            Assert.fail((String)"We expected that future.getTaskId() throws an IllegalStateException!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)future.cancel(false));
        Assert.assertFalse((boolean)future.cancel(true));
        Assert.assertFalse((boolean)future.isCancelled());
        Assert.assertTrue((boolean)future.isDone());
        onFailureLatch.await();
        Assert.assertFalse((boolean)onResponse.get());
    }

    public void testFullRingBuffer_WithExecutionCallback() {
        String key = HazelcastTestSupport.randomString();
        DurableExecutorService service = this.client.getDurableExecutorService(SINGLE_TASK + HazelcastTestSupport.randomString());
        service.submitToKeyOwner((Callable)new ExecutorServiceTestSupport.SleepingTask(100L), (Object)key);
        DurableExecutorServiceFuture future = service.submitToKeyOwner((Callable)new ExecutorServiceTestSupport.BasicTestCallable(), (Object)key);
        final CountDownLatch latch = new CountDownLatch(1);
        future.andThen((ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
            }

            public void onFailure(Throwable t) {
                if (t.getCause() instanceof RejectedExecutionException) {
                    latch.countDown();
                }
            }
        });
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)latch);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.cancel(true));
        Assert.assertFalse((boolean)future.isCancelled());
    }

    @Test
    public void testIsTerminated() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        Assert.assertFalse((boolean)service.isTerminated());
    }

    @Test
    public void testIsShutdown() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        Assert.assertFalse((boolean)service.isShutdown());
    }

    @Test
    public void testShutdownNow() {
        final DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        service.shutdownNow();
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((boolean)service.isShutdown());
            }
        });
    }

    @Test
    public void testShutdownMultipleTimes() {
        final DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        service.shutdownNow();
        service.shutdown();
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((boolean)service.isShutdown());
            }
        });
    }

    @Test
    public void testSubmitFailingCallableException() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        DurableExecutorServiceFuture failingFuture = service.submit((Callable)new FailingCallable());
        this.expectedException.expect(ExecutionException.class);
        failingFuture.get();
    }

    @Test
    public void testSubmitFailingCallableException_withExecutionCallback() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch latch = new CountDownLatch(1);
        service.submit((Callable)new FailingCallable()).andThen((ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
            }

            public void onFailure(Throwable t) {
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testSubmitFailingCallableReasonExceptionCause() throws Exception {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        DurableExecutorServiceFuture future = service.submit((Callable)new FailingCallable());
        this.expectedException.expect((Matcher)new RootCauseMatcher(IllegalStateException.class));
        future.get();
    }

    @Test
    public void testCallableSerializedOnce() throws Exception {
        String name = HazelcastTestSupport.randomString();
        DurableExecutorService service = this.client.getDurableExecutorService(name);
        SerializedCounterCallable counterCallable = new SerializedCounterCallable();
        DurableExecutorServiceFuture future = service.submitToKeyOwner((Callable)counterCallable, (Object)name);
        Assert.assertEquals((Object)2, future.get());
    }

    static class SerializedCounterCallable
    implements Callable,
    DataSerializable {
        int counter;

        public Object call() {
            return this.counter;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(++this.counter);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.counter = in.readInt() + 1;
        }
    }
}

