/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.heartbeat;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientRemovePartitionLostListenerCodec;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientHeartbeatTest
extends ClientTestSupport {
    private static final int HEARTBEAT_TIMEOUT_MILLIS = 10000;
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testOwnerConnectionClosed_whenHeartbeatStopped() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(ClientHeartbeatTest.getClientConfig());
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        ClientConnectionManager connectionManager = clientImpl.getConnectionManager();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        connectionManager.addConnectionListener(new ConnectionListener(){

            public void connectionAdded(Connection connection) {
            }

            public void connectionRemoved(Connection connection) {
                ClientConnection clientConnection = (ClientConnection)connection;
                if (clientConnection.isAuthenticatedAsOwner()) {
                    countDownLatch.countDown();
                }
            }
        });
        this.blockMessagesFromInstance(instance, client);
        ClientHeartbeatTest.assertOpenEventually((CountDownLatch)countDownLatch);
    }

    @Test
    public void testNonOwnerConnectionClosed_whenHeartbeatStopped() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(ClientHeartbeatTest.getClientConfig());
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        final ClientConnectionManager connectionManager = clientImpl.getConnectionManager();
        ClientHeartbeatTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)2L, (long)connectionManager.getActiveConnections().size());
            }
        });
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        connectionManager.addConnectionListener(new ConnectionListener(){

            public void connectionAdded(Connection connection) {
            }

            public void connectionRemoved(Connection connection) {
                ClientConnection clientConnection = (ClientConnection)connection;
                if (!clientConnection.isAuthenticatedAsOwner()) {
                    countDownLatch.countDown();
                }
            }
        });
        this.blockMessagesFromInstance(instance, client);
        ClientHeartbeatTest.assertOpenEventually((CountDownLatch)countDownLatch);
    }

    @Test
    public void testInvocation_whenHeartbeatStopped() throws InterruptedException {
        this.hazelcastFactory.newHazelcastInstance();
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(ClientHeartbeatTest.getClientConfig());
        final HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        ClientHeartbeatTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Member instance2Member = instance2.getCluster().getLocalMember();
                Set partitions = client.getPartitionService().getPartitions();
                boolean found = false;
                for (Partition p : partitions) {
                    if (!p.getOwner().equals(instance2Member)) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((boolean)found);
            }
        });
        String keyOwnedByInstance2 = ClientHeartbeatTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        IMap map = client.getMap(ClientHeartbeatTest.randomString());
        map.put((Object)keyOwnedByInstance2, (Object)ClientHeartbeatTest.randomString());
        this.blockMessagesFromInstance(instance2, client);
        this.expectedException.expect(TargetDisconnectedException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Heartbeat"));
        map.put((Object)keyOwnedByInstance2, (Object)ClientHeartbeatTest.randomString());
    }

    @Test
    public void testAsyncInvocation_whenHeartbeatStopped() throws Throwable {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(ClientHeartbeatTest.getClientConfig());
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        IMap map = client.getMap(ClientHeartbeatTest.randomString());
        String keyOwnedByInstance2 = ClientHeartbeatTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        map.put((Object)keyOwnedByInstance2, (Object)ClientHeartbeatTest.randomString());
        this.blockMessagesFromInstance(instance2, client);
        this.expectedException.expect(TargetDisconnectedException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Heartbeat"));
        try {
            map.putAsync((Object)keyOwnedByInstance2, (Object)ClientHeartbeatTest.randomString()).get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test
    public void testInvocation_whenHeartbeatResumed() throws InterruptedException {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(ClientHeartbeatTest.getClientConfig());
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        String keyOwnedByInstance2 = ClientHeartbeatTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        IMap map = client.getMap(ClientHeartbeatTest.randomString());
        map.put((Object)keyOwnedByInstance2, (Object)ClientHeartbeatTest.randomString());
        this.blockMessagesFromInstance(instance2, client);
        ClientHeartbeatTest.sleepMillis((int)20000);
        this.unblockMessagesFromInstance(instance2, client);
        map.put((Object)keyOwnedByInstance2, (Object)ClientHeartbeatTest.randomString());
    }

    private static ClientConfig getClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.HEARTBEAT_TIMEOUT.getName(), String.valueOf(10000));
        clientConfig.setProperty(ClientProperty.HEARTBEAT_INTERVAL.getName(), "500");
        return clientConfig;
    }

    @Test
    public void testAuthentication_whenHeartbeatResumed() throws Exception {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.setProperty(ClientProperty.SHUFFLE_MEMBER_LIST.getName(), "false");
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        HazelcastClientInstanceImpl hazelcastClientInstanceImpl = this.getHazelcastClientInstanceImpl(client);
        final ClientConnectionManager clientConnectionManager = hazelcastClientInstanceImpl.getConnectionManager();
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                countDownLatch.countDown();
            }
        });
        final HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        this.blockMessagesFromInstance(instance2, client);
        final HazelcastInstance instance3 = this.hazelcastFactory.newHazelcastInstance();
        hazelcastInstance.shutdown();
        ClientHeartbeatTest.assertOpenEventually((CountDownLatch)countDownLatch);
        ClientHeartbeatTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                String uuid = instance3.getLocalEndpoint().getUuid();
                Assert.assertEquals((Object)uuid, (Object)HazelcastTestSupport.getClientEngineImpl((HazelcastInstance)instance3).getOwnerUuid(client.getLocalEndpoint().getUuid()));
                Assert.assertEquals((Object)uuid, (Object)HazelcastTestSupport.getClientEngineImpl((HazelcastInstance)instance2).getOwnerUuid(client.getLocalEndpoint().getUuid()));
                Assert.assertEquals((Object)uuid, (Object)clientConnectionManager.getPrincipal().getOwnerUuid());
                Assert.assertEquals((Object)instance3.getCluster().getLocalMember().getAddress(), (Object)clientConnectionManager.getOwnerConnectionAddress());
            }
        });
        this.unblockMessagesFromInstance(instance2, client);
        ClientHeartbeatTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                String uuid = instance3.getLocalEndpoint().getUuid();
                Assert.assertEquals((Object)uuid, (Object)HazelcastTestSupport.getClientEngineImpl((HazelcastInstance)instance3).getOwnerUuid(client.getLocalEndpoint().getUuid()));
                Assert.assertEquals((Object)uuid, (Object)HazelcastTestSupport.getClientEngineImpl((HazelcastInstance)instance2).getOwnerUuid(client.getLocalEndpoint().getUuid()));
                Assert.assertEquals((Object)uuid, (Object)clientConnectionManager.getPrincipal().getOwnerUuid());
                Assert.assertEquals((Object)instance3.getCluster().getLocalMember().getAddress(), (Object)clientConnectionManager.getOwnerConnectionAddress());
            }
        });
    }

    @Test
    public void testClientEndpointsDelaySeconds_whenHeartbeatResumed() throws Exception {
        int delaySeconds = 2;
        Config config = new Config();
        config.setProperty(GroupProperty.CLIENT_ENDPOINT_REMOVE_DELAY_SECONDS.getName(), String.valueOf(delaySeconds));
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(ClientHeartbeatTest.getClientConfig());
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        LifecycleService lifecycleService = client.getLifecycleService();
        lifecycleService.addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED == event.getState()) {
                    disconnectedLatch.countDown();
                }
            }
        });
        this.blockMessagesFromInstance(hazelcastInstance, client);
        ClientHeartbeatTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        final AtomicLong stateChangeCount = new AtomicLong();
        lifecycleService.addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                stateChangeCount.incrementAndGet();
                Logger.getLogger(this.getClass()).info("state event: " + event);
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED == event.getState()) {
                    connectedLatch.countDown();
                }
            }
        });
        this.unblockMessagesFromInstance(hazelcastInstance, client);
        ClientHeartbeatTest.assertOpenEventually((CountDownLatch)connectedLatch);
        ClientHeartbeatTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)stateChangeCount.get());
            }
        }, (long)(delaySeconds * 2));
    }

    @Test
    public void testAddingListenerToNewConnectionFailedBecauseOfHeartbeat() throws Exception {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(ClientHeartbeatTest.getClientConfig());
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(client);
        ClientListenerService clientListenerService = clientInstanceImpl.getListenerService();
        final CountDownLatch blockIncoming = new CountDownLatch(1);
        final CountDownLatch heartbeatStopped = new CountDownLatch(1);
        final CountDownLatch onListenerRegister = new CountDownLatch(2);
        clientInstanceImpl.getConnectionManager().addConnectionListener(new ConnectionListener(){

            public void connectionAdded(Connection connection) {
            }

            public void connectionRemoved(Connection connection) {
                heartbeatStopped.countDown();
            }
        });
        clientListenerService.registerListener(this.createPartitionLostListenerCodec(), new EventHandler(){
            AtomicInteger count = new AtomicInteger(0);

            public void handle(Object event) {
            }

            public void beforeListenerRegister() {
                if (this.count.incrementAndGet() == 2) {
                    try {
                        blockIncoming.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onListenerRegister() {
                onListenerRegister.countDown();
            }
        });
        HazelcastInstance hazelcastInstance2 = this.hazelcastFactory.newHazelcastInstance();
        ClientHeartbeatTest.assertSizeEventually((int)2, (Collection)clientInstanceImpl.getConnectionManager().getActiveConnections());
        this.blockMessagesFromInstance(hazelcastInstance2, client);
        ClientHeartbeatTest.assertOpenEventually((CountDownLatch)heartbeatStopped);
        blockIncoming.countDown();
        this.unblockMessagesFromInstance(hazelcastInstance2, client);
        ClientHeartbeatTest.assertOpenEventually((CountDownLatch)onListenerRegister);
    }

    private ListenerMessageCodec createPartitionLostListenerCodec() {
        return new ListenerMessageCodec(){

            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ClientAddPartitionLostListenerCodec.encodeRequest((boolean)localOnly);
            }

            public String decodeAddResponse(ClientMessage clientMessage) {
                return ClientAddPartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ClientRemovePartitionLostListenerCodec.encodeRequest((String)realRegistrationId);
            }

            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ClientRemovePartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }
}

