/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Log4j2Factory;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.IsolatedLoggingRule;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientLoggerConfigurationTest
extends HazelcastTestSupport {
    @Rule
    public final IsolatedLoggingRule isolatedLoggingRule = new IsolatedLoggingRule();
    private TestHazelcastFactory hazelcastFactory;

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    @Test
    public void testProgrammaticConfiguration() {
        this.testLoggingWithConfiguration(true);
    }

    @Test
    public void testSystemPropertyConfiguration() {
        this.testLoggingWithConfiguration(false);
    }

    protected void testLoggingWithConfiguration(boolean programmaticConfiguration) {
        this.hazelcastFactory = new TestHazelcastFactory();
        Config cg = new Config();
        cg.setProperty("hazelcast.logging.type", "jdk");
        this.hazelcastFactory.newHazelcastInstance(cg);
        ClientConfig config = new ClientConfig();
        if (programmaticConfiguration) {
            config.setProperty("hazelcast.logging.type", "log4j2");
        } else {
            this.isolatedLoggingRule.setLoggingType("log4j2");
        }
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        ILogger clientLogger = client.getLoggingService().getLogger("loggerName");
        ILogger actualLogger = (ILogger)ClientLoggerConfigurationTest.getFromField((Object)clientLogger, (String)"logger");
        Class<?> clientLoggerClass = actualLogger.getClass();
        ILogger expectedLogger = new Log4j2Factory().getLogger("expectedLogger");
        Class<?> expectedLoggerClass = expectedLogger.getClass();
        Assert.assertSame(expectedLoggerClass, clientLoggerClass);
    }
}

