/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.logging.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientLoggingServiceTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory;
    private LoggingService loggingService;
    private LogListener logListener;
    private LogEvent logEvent;

    @Before
    public void setUp() {
        this.factory = new TestHazelcastFactory();
        HazelcastInstance member = this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.loggingService = client.getLoggingService();
        this.logListener = new LogListener(){

            public void log(LogEvent logEvent) {
            }
        };
        this.logEvent = new LogEvent(null, member.getCluster().getLocalMember());
    }

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLogListener() {
        this.loggingService.addLogListener(Level.INFO, this.logListener);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveLogListener() {
        this.loggingService.removeLogListener(this.logListener);
    }

    @Test
    public void testLog_whenLogEvent_thenNothingHappens() {
        ILogger logger = this.loggingService.getLogger("test");
        logger.log(this.logEvent);
    }

    @Test
    public void testLog_whenGetLevel_thenDefaultLevelIsReturned() {
        ILogger logger = this.loggingService.getLogger("test");
        Assert.assertNotNull((Object)logger.getLevel());
    }
}

