/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.UndefinedErrorCodeException;
import com.hazelcast.client.impl.clientside.ClientExceptionFactory;
import com.hazelcast.client.impl.protocol.ClientExceptions;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.exception.MaxMessageSizeExceeded;
import com.hazelcast.client.impl.protocol.util.ClientProtocolBuffer;
import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.ConsistencyLostException;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.IndeterminateOperationStateException;
import com.hazelcast.core.LocalMemberResetException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.crdt.MutationDisallowedException;
import com.hazelcast.crdt.TargetNotReplicaException;
import com.hazelcast.durableexecutor.StaleTaskIdException;
import com.hazelcast.internal.cluster.impl.ConfigMismatchException;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.ReachedMaxSizeException;
import com.hazelcast.mapreduce.RemoteMapReduceException;
import com.hazelcast.mapreduce.TopologyChangedException;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.query.QueryException;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.TopicOverloadException;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionTimedOutException;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.wan.WANReplicationQueueFullException;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.UTFDataFormatException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import javax.cache.CacheException;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessorException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.transaction.xa.XAException;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientExceptionFactoryTest
extends HazelcastTestSupport {
    @Parameterized.Parameter
    public Throwable throwable;
    private ClientExceptions exceptions = new ClientExceptions(true);
    private ClientExceptionFactory exceptionFactory = new ClientExceptionFactory(true);

    @Test
    public void testException() {
        ClientMessage exceptionMessage = this.exceptions.createExceptionMessage(this.throwable);
        ClientMessage responseMessage = ClientMessage.createForDecode((ClientProtocolBuffer)exceptionMessage.buffer(), (int)0);
        Throwable resurrectedThrowable = this.exceptionFactory.createException(responseMessage);
        if (!this.exceptionEquals(this.throwable, resurrectedThrowable)) {
            TestCase.assertEquals((Object)this.throwable, (Object)resurrectedThrowable);
        }
    }

    private boolean exceptionEquals(Throwable expected, Throwable actual) {
        if (expected == null && actual == null) {
            return true;
        }
        if (expected == null || actual == null) {
            return false;
        }
        if (this.exceptions.isKnownClass(expected.getClass())) {
            if (!expected.getClass().equals(actual.getClass())) {
                return false;
            }
            if (expected.getClass() != URISyntaxException.class && !ClientExceptionFactoryTest.equals(expected.getMessage(), actual.getMessage())) {
                return false;
            }
        } else if (!UndefinedErrorCodeException.class.equals(actual.getClass()) || !expected.getClass().getName().equals(((UndefinedErrorCodeException)actual).getOriginClassName())) {
            return false;
        }
        if (!this.stackTraceArrayEquals(expected.getStackTrace(), actual.getStackTrace())) {
            return false;
        }
        return this.exceptionEquals(expected.getCause(), actual.getCause());
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private boolean stackTraceArrayEquals(StackTraceElement[] stackTrace1, StackTraceElement[] stackTrace2) {
        TestCase.assertEquals((int)stackTrace1.length, (int)stackTrace2.length);
        for (int i = 0; i < stackTrace1.length; ++i) {
            StackTraceElement stackTraceElement1 = stackTrace1[i];
            StackTraceElement stackTraceElement2 = stackTrace2[i];
            if (ClientExceptionFactoryTest.equals(stackTraceElement1.getClassName(), stackTraceElement2.getClassName()) && ClientExceptionFactoryTest.equals(stackTraceElement1.getMethodName(), stackTraceElement2.getMethodName()) && ClientExceptionFactoryTest.equals(stackTraceElement1.getFileName(), stackTraceElement2.getFileName()) && ClientExceptionFactoryTest.equals(stackTraceElement1.getLineNumber(), stackTraceElement2.getLineNumber())) continue;
            return false;
        }
        return true;
    }

    @Parameterized.Parameters(name="Throwable:{0}")
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({new CacheException(ClientExceptionFactoryTest.randomString())}, {new CacheLoaderException(ClientExceptionFactoryTest.randomString())}, {new CacheWriterException(ClientExceptionFactoryTest.randomString())}, {new EntryProcessorException(ClientExceptionFactoryTest.randomString())}, {new ArrayIndexOutOfBoundsException(ClientExceptionFactoryTest.randomString())}, {new ArrayStoreException(ClientExceptionFactoryTest.randomString())}, {new AuthenticationException(ClientExceptionFactoryTest.randomString())}, {new CacheNotExistsException(ClientExceptionFactoryTest.randomString())}, {new CallerNotMemberException(ClientExceptionFactoryTest.randomString())}, {new CancellationException(ClientExceptionFactoryTest.randomString())}, {new ClassCastException(ClientExceptionFactoryTest.randomString())}, {new ClassNotFoundException(ClientExceptionFactoryTest.randomString())}, {new ConcurrentModificationException(ClientExceptionFactoryTest.randomString())}, {new ConfigMismatchException(ClientExceptionFactoryTest.randomString())}, {new ConfigurationException(ClientExceptionFactoryTest.randomString())}, {new DistributedObjectDestroyedException(ClientExceptionFactoryTest.randomString())}, {new DuplicateInstanceNameException(ClientExceptionFactoryTest.randomString())}, {new EOFException(ClientExceptionFactoryTest.randomString())}, {new ExecutionException(new IOException())}, {new HazelcastException(ClientExceptionFactoryTest.randomString())}, {new HazelcastInstanceNotActiveException(ClientExceptionFactoryTest.randomString())}, {new HazelcastOverloadException(ClientExceptionFactoryTest.randomString())}, {new HazelcastSerializationException(ClientExceptionFactoryTest.randomString())}, {new IOException(ClientExceptionFactoryTest.randomString())}, {new IllegalArgumentException(ClientExceptionFactoryTest.randomString())}, {new IllegalAccessException(ClientExceptionFactoryTest.randomString())}, {new IllegalAccessError(ClientExceptionFactoryTest.randomString())}, {new IllegalMonitorStateException(ClientExceptionFactoryTest.randomString())}, {new IllegalStateException(ClientExceptionFactoryTest.randomString())}, {new IllegalThreadStateException(ClientExceptionFactoryTest.randomString())}, {new IndexOutOfBoundsException(ClientExceptionFactoryTest.randomString())}, {new InterruptedException(ClientExceptionFactoryTest.randomString())}, {new AddressUtil.InvalidAddressException(ClientExceptionFactoryTest.randomString())}, {new InvalidConfigurationException(ClientExceptionFactoryTest.randomString())}, {new MemberLeftException(ClientExceptionFactoryTest.randomString())}, {new NegativeArraySizeException(ClientExceptionFactoryTest.randomString())}, {new NoSuchElementException(ClientExceptionFactoryTest.randomString())}, {new NotSerializableException(ClientExceptionFactoryTest.randomString())}, {new NullPointerException(ClientExceptionFactoryTest.randomString())}, {new OperationTimeoutException(ClientExceptionFactoryTest.randomString())}, {new PartitionMigratingException(ClientExceptionFactoryTest.randomString())}, {new QueryException(ClientExceptionFactoryTest.randomString())}, {new QueryResultSizeExceededException(ClientExceptionFactoryTest.randomString())}, {new QuorumException(ClientExceptionFactoryTest.randomString())}, {new ReachedMaxSizeException(ClientExceptionFactoryTest.randomString())}, {new RejectedExecutionException(ClientExceptionFactoryTest.randomString())}, {new RemoteMapReduceException(ClientExceptionFactoryTest.randomMapName(), Collections.emptyList())}, {new ResponseAlreadySentException(ClientExceptionFactoryTest.randomString())}, {new RetryableHazelcastException(ClientExceptionFactoryTest.randomString())}, {new RetryableIOException(ClientExceptionFactoryTest.randomString())}, {new RuntimeException(ClientExceptionFactoryTest.randomString())}, {new SecurityException(ClientExceptionFactoryTest.randomString())}, {new SocketException(ClientExceptionFactoryTest.randomString())}, {new StaleSequenceException(ClientExceptionFactoryTest.randomString(), 1L)}, {new StaleTaskIdException(ClientExceptionFactoryTest.randomString())}, {new TargetDisconnectedException(ClientExceptionFactoryTest.randomString())}, {new TargetNotMemberException(ClientExceptionFactoryTest.randomString())}, {new TimeoutException(ClientExceptionFactoryTest.randomString())}, {new TopicOverloadException(ClientExceptionFactoryTest.randomString())}, {new TopologyChangedException(ClientExceptionFactoryTest.randomString())}, {new TransactionException(ClientExceptionFactoryTest.randomString())}, {new TransactionNotActiveException(ClientExceptionFactoryTest.randomString())}, {new TransactionTimedOutException(ClientExceptionFactoryTest.randomString())}, {new URISyntaxException(ClientExceptionFactoryTest.randomString(), ClientExceptionFactoryTest.randomString())}, {new UTFDataFormatException(ClientExceptionFactoryTest.randomString())}, {new UnsupportedOperationException(ClientExceptionFactoryTest.randomString())}, {new WrongTargetException(ClientExceptionFactoryTest.randomString())}, {new XAException(ClientExceptionFactoryTest.randomString())}, {new AccessControlException(ClientExceptionFactoryTest.randomString())}, {new LoginException(ClientExceptionFactoryTest.randomString())}, {new UnsupportedCallbackException(new Callback(){})}, {new NoDataMemberInClusterException(ClientExceptionFactoryTest.randomString())}, {new ReplicatedMapCantBeCreatedOnLiteMemberException(ClientExceptionFactoryTest.randomString())}, {new MaxMessageSizeExceeded()}, {new WANReplicationQueueFullException(ClientExceptionFactoryTest.randomString())}, {new AssertionError((Object)ClientExceptionFactoryTest.randomString())}, {new OutOfMemoryError(ClientExceptionFactoryTest.randomString())}, {new StackOverflowError(ClientExceptionFactoryTest.randomString())}, {new NativeOutOfMemoryError(ClientExceptionFactoryTest.randomString())}, {new RuntimeException("re1", new RuntimeException(new IOException("ioe")))}, {new RuntimeException()}, {new RuntimeException(new RuntimeException("blabla"))}, {new RuntimeException("blabla", new NullPointerException())}, {new RuntimeException("blabla", (Throwable)new HazelcastTestSupport.DummyUncheckedHazelcastTestException())}, {new RuntimeException("fun", new RuntimeException("codec \n is \n not \n pwned"))}, {new RuntimeException("fun", new RuntimeException("!@#$%^&*()'][/.,l;\u00a7!|`]:\\\u013e\u0161\u010d\u0165\u017e /s\u1d7b\u02c8r\u026al\u026ak/ \u00c1\u0437\u0431\u0443\u043a\u0430 \u4e2d\u534e\u6c11\u65cf \n \r \t \r\n"))}, {new LocalMemberResetException(ClientExceptionFactoryTest.randomString())}, {new IndeterminateOperationStateException(ClientExceptionFactoryTest.randomString())}, {new TargetNotReplicaException(ClientExceptionFactoryTest.randomString())}, {new MutationDisallowedException(ClientExceptionFactoryTest.randomString())}, {new ConsistencyLostException(ClientExceptionFactoryTest.randomString())});
    }
}

