/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.client.UndefinedErrorCodeException;
import com.hazelcast.client.impl.clientside.ClientExceptionFactory;
import com.hazelcast.client.impl.protocol.ClientExceptions;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.ClientProtocolErrorCodes;
import com.hazelcast.client.impl.protocol.util.ClientProtocolBuffer;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientProtocolErrorCodesTest
extends HazelcastTestSupport {
    @Test
    public void testConstructor() {
        ClientProtocolErrorCodesTest.assertUtilityConstructor(ClientProtocolErrorCodes.class);
    }

    @Test
    public void testUndefinedException() {
        ClientExceptions exceptions = new ClientExceptions(false);
        ClientExceptionFactory exceptionFactory = new ClientExceptionFactory(false);
        class MyException
        extends Exception {
            MyException() {
            }
        }
        ClientMessage exceptionMessage = exceptions.createExceptionMessage((Throwable)new MyException());
        ClientMessage responseMessage = ClientMessage.createForDecode((ClientProtocolBuffer)exceptionMessage.buffer(), (int)0);
        Throwable resurrectedThrowable = exceptionFactory.createException(responseMessage);
        TestCase.assertEquals(UndefinedErrorCodeException.class, resurrectedThrowable.getClass());
    }
}

