/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.impl.querycache.NodeQueryCacheContextTest;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheScheduler;
import com.hazelcast.nio.Address;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheContextTest
extends HazelcastTestSupport {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private TestHazelcastFactory factory;
    private QueryCacheContext context;

    @Before
    public void setUp() {
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        ClientMapProxy proxy = (ClientMapProxy)hz.getMap("test");
        this.context = proxy.getQueryCacheContext();
    }

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testDestroy() {
        this.context.destroy();
    }

    @Test
    public void testGetMemberList() {
        Collection memberList = this.context.getMemberList();
        Assert.assertNotNull((Object)memberList);
        Assert.assertEquals((long)1L, (long)memberList.size());
    }

    @Test
    public void testPartitionId() {
        int partitionId = this.context.getPartitionId((Object)"myKey");
        Assert.assertTrue((partitionId >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetQueryCacheScheduler() {
        QueryCacheScheduler scheduler = this.context.getQueryCacheScheduler();
        Assert.assertNotNull((Object)scheduler);
        final NodeQueryCacheContextTest.QuerySchedulerTask task = new NodeQueryCacheContextTest.QuerySchedulerTask();
        scheduler.execute((Runnable)task);
        final NodeQueryCacheContextTest.QuerySchedulerRepetitionTask repetitionTask = new NodeQueryCacheContextTest.QuerySchedulerRepetitionTask();
        scheduler.scheduleWithRepetition((Runnable)repetitionTask, 1L);
        ClientQueryCacheContextTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((boolean)task.executed);
                Assert.assertTrue((repetitionTask.counter.get() > 1 ? 1 : 0) != 0);
            }
        });
        scheduler.shutdown();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetPublisherContext() {
        this.context.getPublisherContext();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetThisNodesAddress() {
        this.context.getThisNodesAddress();
    }

    @Test(expected=NullPointerException.class)
    public void testInvokerWrapper_invokeOnAllPartitions_whenExceptionOccurs_thenExceptionIsRethrown() throws Exception {
        ClientMessage request = (ClientMessage)Mockito.mock(ClientMessage.class);
        Mockito.when((Object)request.setCorrelationId(((Long)Matchers.any()).longValue())).thenThrow(NullPointerException.class);
        this.context.getInvokerWrapper().invokeOnAllPartitions((Object)request);
    }

    @Test(expected=NullPointerException.class)
    public void testInvokerWrapper_invokeOnTarget_whenExceptionOccurs_thenExceptionIsRethrown() throws Exception {
        ClientMessage request = (ClientMessage)Mockito.mock(ClientMessage.class);
        Mockito.when((Object)request.setCorrelationId(((Long)Matchers.any()).longValue())).thenThrow(NullPointerException.class);
        Address address = new Address();
        this.context.getInvokerWrapper().invokeOnTarget((Object)request, address);
    }

    @Test(expected=NullPointerException.class)
    public void testInvokerWrapper_invokeOnTarget_whenRequestIsNull_thenThrowException() {
        Address address = new Address();
        this.context.getInvokerWrapper().invokeOnTarget(null, address);
    }

    @Test(expected=NullPointerException.class)
    public void testInvokerWrapper_invokeOnTarget_whenAddressIsNull_thenThrowException() {
        this.context.getInvokerWrapper().invokeOnTarget(new Object(), null);
    }

    @Test(expected=NullPointerException.class)
    public void testInvokerWrapper_invoke_whenExceptionOccurs_thenExceptionIsRethrown() throws Exception {
        ClientMessage request = (ClientMessage)Mockito.mock(ClientMessage.class);
        Mockito.when((Object)request.setCorrelationId(((Long)Matchers.any()).longValue())).thenThrow(NullPointerException.class);
        this.context.getInvokerWrapper().invoke((Object)request);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInvokerWrapper_executeOperation() {
        this.context.getInvokerWrapper().executeOperation(null);
    }
}

