/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.io;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.Partition;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.nio.Address;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class AdvancedNetworkClientIntegrationTest {
    private static final int CLUSTER_SIZE = 3;
    private static final int BASE_CLIENT_PORT = 9090;
    private HazelcastInstance[] instances = new HazelcastInstance[3];
    private HazelcastInstance client;

    @Before
    public void setup() {
        for (int i = 0; i < 3; ++i) {
            this.instances[i] = Hazelcast.newHazelcastInstance((Config)this.getConfig());
        }
        HazelcastTestSupport.assertClusterSizeEventually((int)3, (HazelcastInstance[])this.instances);
    }

    @After
    public void tearDown() {
        this.client.shutdown();
        for (int i = 0; i < 3; ++i) {
            this.instances[i].getLifecycleService().terminate();
        }
    }

    @Test
    public void clientSmokeTest() {
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.getClientConfig());
        IMap map = this.client.getMap("test");
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i);
        }
        Assert.assertEquals((long)1000L, (long)map.size());
    }

    @Test
    public void testClientMembersList() {
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.getClientConfig());
        Set clientViewOfMembers = this.client.getCluster().getMembers();
        Set members = this.instances[1].getCluster().getMembers();
        HashSet<Address> clientViewOfAddresses = new HashSet<Address>();
        for (Member member : clientViewOfMembers) {
            clientViewOfAddresses.add(member.getAddress());
        }
        for (Member member : members) {
            HazelcastTestSupport.assertContains(clientViewOfAddresses, member.getAddressMap().get(EndpointQualifier.CLIENT));
        }
    }

    @Test
    public void testClientMembershipEvent() {
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.getClientConfig());
        final AtomicReference memberAdded = new AtomicReference();
        final AtomicReference memberRemoved = new AtomicReference();
        Address removedMemberAddress = (Address)this.instances[2].getCluster().getLocalMember().getAddressMap().get(EndpointQualifier.CLIENT);
        this.client.getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                memberAdded.set(membershipEvent.getMember());
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                memberRemoved.set(membershipEvent.getMember());
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
        this.instances[2].shutdown();
        HazelcastTestSupport.assertClusterSizeEventually((int)2, (HazelcastInstance[])new HazelcastInstance[]{this.instances[0]});
        Assert.assertEquals((Object)((Member)memberRemoved.get()).getAddress(), (Object)removedMemberAddress);
        this.instances[2] = Hazelcast.newHazelcastInstance((Config)this.getConfig());
        HazelcastTestSupport.assertClusterSizeEventually((int)3, (HazelcastInstance[])this.instances);
        Assert.assertEquals((Object)((Member)memberAdded.get()).getAddress(), this.instances[2].getCluster().getLocalMember().getAddressMap().get(EndpointQualifier.CLIENT));
    }

    @Test
    public void testPartitions() {
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.getClientConfig());
        Iterator memberPartitions = this.instances[0].getPartitionService().getPartitions().iterator();
        Set partitions = this.client.getPartitionService().getPartitions();
        for (Partition partition : partitions) {
            Partition memberPartition = (Partition)memberPartitions.next();
            Assert.assertEquals((long)memberPartition.getPartitionId(), (long)partition.getPartitionId());
            Assert.assertEquals(memberPartition.getOwner().getAddressMap().get(EndpointQualifier.CLIENT), (Object)partition.getOwner().getAddress());
        }
    }

    @Test
    public void testGetScheduledFutures() throws Exception {
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.getClientConfig());
        IScheduledExecutorService executorService = this.client.getScheduledExecutorService("test");
        Member targetMember = (Member)this.client.getCluster().getMembers().iterator().next();
        IScheduledFuture future = executorService.scheduleOnMember((Callable)new ReportExecutionMember(), targetMember, 3L, TimeUnit.SECONDS);
        Map futures = executorService.getAllScheduledFutures();
        HazelcastTestSupport.assertContains(futures.keySet(), (Object)targetMember);
        IScheduledFuture futureOfMember = (IScheduledFuture)((List)futures.get(targetMember)).get(0);
        Assert.assertEquals((Object)futureOfMember.get(), (Object)future.get());
    }

    @Test
    public void testScheduleOnMember() throws Exception {
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.getClientConfig());
        IScheduledExecutorService executorService = this.client.getScheduledExecutorService("test");
        Member targetMember = (Member)this.client.getCluster().getMembers().iterator().next();
        IScheduledFuture future = executorService.scheduleOnMember((Callable)new ReportExecutionMember(), targetMember, 3L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)targetMember.getAddress(), (Object)future.getHandler().getAddress());
        Address clusterMemberAddress = null;
        for (HazelcastInstance instance : this.instances) {
            if (!targetMember.getAddress().equals(instance.getCluster().getLocalMember().getAddressMap().get(EndpointQualifier.CLIENT))) continue;
            clusterMemberAddress = instance.getCluster().getLocalMember().getAddress();
        }
        Assert.assertEquals((Object)future.get(), clusterMemberAddress);
    }

    private Config getConfig() {
        Config config = HazelcastTestSupport.smallInstanceConfig();
        config.getAdvancedNetworkConfig().setEnabled(true).setClientEndpointConfig(new ServerSocketEndpointConfig().setPort(9090));
        config.getAdvancedNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getAdvancedNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true).addMember("127.0.0.1");
        return config;
    }

    private ClientConfig getClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{"127.0.0.1:9090"});
        return clientConfig;
    }

    public static class ReportExecutionMember
    implements Callable<Address>,
    Serializable,
    HazelcastInstanceAware {
        private volatile HazelcastInstance instance;

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.instance = hazelcastInstance;
        }

        @Override
        public Address call() {
            return this.instance.getCluster().getLocalMember().getAddress();
        }
    }
}

