/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.listeners;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ListenerTests
extends ClientTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test
    public void testSmartListenerRegister_whenNodeLeft() {
        int nodeCount = 5;
        for (int i = 0; i < nodeCount - 1; ++i) {
            this.factory.newHazelcastInstance();
        }
        final HazelcastInstance node = this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap("test");
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                node.getLifecycleService().terminate();
            }
        }, 500L, TimeUnit.MILLISECONDS);
        EntryAdapter listener = new EntryAdapter();
        LinkedList<String> registrationIds = new LinkedList<String>();
        while (client.getCluster().getMembers().size() == nodeCount) {
            registrationIds.add(map.addEntryListener((EntryListener)listener, false));
        }
        for (String registrationId : registrationIds) {
            TestCase.assertTrue((boolean)map.removeEntryListener(registrationId));
        }
        executorService.shutdown();
    }

    @Test
    public void testSmartListenerRegister_whenNodeJoined() {
        int nodeCount = 5;
        for (int i = 0; i < nodeCount - 1; ++i) {
            this.factory.newHazelcastInstance();
        }
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap("test");
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                ListenerTests.this.factory.newHazelcastInstance();
            }
        }, 500L, TimeUnit.MILLISECONDS);
        EntryAdapter listener = new EntryAdapter();
        LinkedList<String> registrationIds = new LinkedList<String>();
        HazelcastClientInstanceImpl clientInstance = this.getHazelcastClientInstanceImpl(client);
        while (clientInstance.getConnectionManager().getActiveConnections().size() < nodeCount) {
            registrationIds.add(map.addEntryListener((EntryListener)listener, false));
        }
        for (String registrationId : registrationIds) {
            TestCase.assertTrue((boolean)map.removeEntryListener(registrationId));
        }
        executorService.shutdown();
    }

    @Test
    public void testRemoveListenerOnClosedClient() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap("test");
        client.shutdown();
        TestCase.assertTrue((boolean)map.removeEntryListener("test"));
    }
}

