/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.listeners.leak;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.clientside.ClientTestUtil;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.instance.Node;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ListenerLeakTest
extends HazelcastTestSupport {
    @Parameterized.Parameter
    public boolean smartRouting;
    protected final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="smartRouting:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false}, {true});
    }

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    private void assertNoLeftOver(Collection<Node> nodes, HazelcastInstance client, String id, Collection<ClientEventRegistration> registrations) {
        for (Node node : nodes) {
            this.assertNoLeftOverOnNode(node, registrations);
        }
        Assert.assertEquals((long)0L, (long)this.getClientEventRegistrations(client, id).size());
    }

    private Collection<Node> createNodes() {
        int NODE_COUNT = 3;
        ArrayList<Node> nodes = new ArrayList<Node>(3);
        for (int i = 0; i < NODE_COUNT; ++i) {
            HazelcastInstance hazelcast = this.hazelcastFactory.newHazelcastInstance();
            nodes.add(ListenerLeakTest.getNode((HazelcastInstance)hazelcast));
        }
        return nodes;
    }

    private void assertNoLeftOverOnNode(Node node, Collection<ClientEventRegistration> registrations) {
        Collection endpoints = node.clientEngine.getEndpointManager().getEndpoints();
        for (ClientEndpoint endpoint : endpoints) {
            for (ClientEventRegistration registration : registrations) {
                Assert.assertFalse((boolean)endpoint.removeDestroyAction(registration.getServerRegistrationId()));
            }
        }
    }

    private Collection<ClientEventRegistration> getClientEventRegistrations(HazelcastInstance client, String id) {
        HazelcastClientInstanceImpl clientImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        AbstractClientListenerService listenerService = (AbstractClientListenerService)clientImpl.getListenerService();
        return listenerService.getActiveRegistrations(id);
    }

    private HazelcastInstance newHazelcastClient() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(this.smartRouting);
        return this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @Test
    public void testMapEntryListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        IMap map = client.getMap(ListenerLeakTest.randomString());
        String id = map.addEntryListener((MapListener)Mockito.mock(MapListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)map.removeEntryListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testMapPartitionLostListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        IMap map = client.getMap(ListenerLeakTest.randomString());
        String id = map.addPartitionLostListener((MapPartitionLostListener)Mockito.mock(MapPartitionLostListener.class));
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)map.removePartitionLostListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testMultiMapEntryListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        MultiMap multiMap = client.getMultiMap(ListenerLeakTest.randomString());
        String id = multiMap.addEntryListener((EntryListener)Mockito.mock(EntryListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)multiMap.removeEntryListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testListListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        IList list = client.getList(ListenerLeakTest.randomString());
        String id = list.addItemListener((ItemListener)Mockito.mock(ItemListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)list.removeItemListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testSetListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        ISet set = client.getSet(ListenerLeakTest.randomString());
        String id = set.addItemListener((ItemListener)Mockito.mock(ItemListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)set.removeItemListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testQueueListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        IQueue queue = client.getQueue(ListenerLeakTest.randomString());
        String id = queue.addItemListener((ItemListener)Mockito.mock(ItemListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)queue.removeItemListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testReplicatedMapListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        ReplicatedMap replicatedMap = client.getReplicatedMap(ListenerLeakTest.randomString());
        String id = replicatedMap.addEntryListener((EntryListener)Mockito.mock(EntryListener.class));
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)replicatedMap.removeEntryListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testDistributedObjectListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        String id = client.addDistributedObjectListener((DistributedObjectListener)Mockito.mock(DistributedObjectListener.class));
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)client.removeDistributedObjectListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testTopicMessageListener() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        ITopic topic = client.getTopic(ListenerLeakTest.randomString());
        String id = topic.addMessageListener((MessageListener)Mockito.mock(MessageListener.class));
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)topic.removeMessageListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testEventHandlersRemovedOnDisconnectedState() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(this.smartRouting);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance hazelcast = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        hazelcast.shutdown();
        HazelcastClientInstanceImpl clientImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        final AbstractClientListenerService listenerService = (AbstractClientListenerService)clientImpl.getListenerService();
        ListenerLeakTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)0L, (long)listenerService.getEventHandlers().size());
            }
        });
    }
}

