/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.lock;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientConcurrentLockTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void concurrent_TryLockTest() throws InterruptedException {
        this.concurrent_LockTest(false);
    }

    @Test
    public void concurrent_TryLock_WithTimeOutTest() throws InterruptedException {
        this.concurrent_LockTest(true);
    }

    private void concurrent_LockTest(boolean tryLockWithTimeOut) {
        ILock lock = this.client.getLock(HazelcastTestSupport.randomString());
        AtomicInteger upTotal = new AtomicInteger(0);
        AtomicInteger downTotal = new AtomicInteger(0);
        Thread[] threads = new LockTestThread[8];
        for (int i = 0; i < threads.length; ++i) {
            LockTestThread t = tryLockWithTimeOut ? new TryLockWithTimeOutThread(lock, upTotal, downTotal) : new TryLockThread(lock, upTotal, downTotal);
            t.start();
            threads[i] = t;
        }
        HazelcastTestSupport.assertJoinable((Thread[])threads);
        Assert.assertEquals((String)"concurrent access to locked code caused wrong total", (long)0L, (long)(upTotal.get() + downTotal.get()));
    }

    static abstract class LockTestThread
    extends Thread {
        private static final int ITERATIONS = 10000;
        private final Random random = new Random();
        protected final ILock lock;
        protected final AtomicInteger upTotal;
        protected final AtomicInteger downTotal;

        public LockTestThread(ILock lock, AtomicInteger upTotal, AtomicInteger downTotal) {
            this.lock = lock;
            this.upTotal = upTotal;
            this.downTotal = downTotal;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 10000; ++i) {
                    this.doRun();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("LockTestThread throws: ", e);
            }
        }

        abstract void doRun() throws Exception;

        protected void work() {
            int delta = this.random.nextInt(1000);
            this.upTotal.addAndGet(delta);
            this.downTotal.addAndGet(-delta);
        }
    }

    static class TryLockWithTimeOutThread
    extends LockTestThread {
        public TryLockWithTimeOutThread(ILock lock, AtomicInteger upTotal, AtomicInteger downTotal) {
            super(lock, upTotal, downTotal);
        }

        @Override
        public void doRun() throws Exception {
            if (this.lock.tryLock(1L, TimeUnit.MILLISECONDS)) {
                this.work();
                this.lock.unlock();
            }
        }
    }

    static class TryLockThread
    extends LockTestThread {
        public TryLockThread(ILock lock, AtomicInteger upTotal, AtomicInteger downTotal) {
            super(lock, upTotal, downTotal);
        }

        @Override
        public void doRun() {
            if (this.lock.tryLock()) {
                this.work();
                this.lock.unlock();
            }
        }
    }
}

